/**
 * @file
 * @deprecated
 */
#ifndef MIME_COMPONENT_H
#define MIME_COMPONENT_H

//#include <mimeparser/config.h>
#include <iostream>
#include <string>

namespace mulca_mime {


class component {
public:
    component(const std::string& buf) : buffer(buf), offset_(0), length_(0) { };

    virtual ~component() {};

    std::string::size_type  offset() const {
        return offset_;
    };
    std::string::size_type  length() const {
        return length_;
    };
    const char* data() const {
        return buffer.c_str() + offset();
    }

    const std::string asString() const {
        if (offset_ > buffer.length()) {
            offset_ = 0;
            std::cerr<<"offset_ > buffer.length()\n";
        }
        if (length_ > buffer.length()) {
            length_ = buffer.length();
            std::cerr<<"length_ > buffer.length()\n";
        }
        return std::string(buffer.begin()+offset_, buffer.begin()+offset_+length_);
    };

    virtual std::string::size_type parse(int inlineLevel, const std::string::size_type beg, const std::string::size_type end,int level=0) = 0;
    virtual std::string::size_type parse(const std::string::size_type beg, const std::string::size_type end,int level=0) = 0;

    std::string::size_type& offset() {
        return offset_;
    };
    std::string::size_type& length() {
        return length_;
    };

protected:
    const std::string& buffer;
    mutable std::string::size_type offset_;
    mutable std::string::size_type length_;
};


};

#endif

