/**
 * @file
 * @deprecated
 */
#ifndef MIME_HEADER_H
#define MIME_HEADER_H

//#include <mimeparser/config.h>
#include <string>
#include <mimeparser/component.h>
#include <mimeparser/rfc2822address.h>
#include <mimeparser/parameters.h>
#include <vector>


namespace mulca_mime {
using rfc2822::rfc2822address;

class header : public component {
public:
    header(const std::string& buf) : component(buf), from(0), to(0), cc(0), parse_full_mode(false) {
        //default values
        content_type.type="text";
        content_type.subtype="plain";
        content_type.charset="US-ASCII";
        content_transfer_encoding="7bit";
    };
    virtual ~header();

    virtual std::string::size_type parse(int inlineLevel, const std::string::size_type beg, const std::string::size_type end,int level=0);
    virtual std::string::size_type parse(const std::string::size_type beg, const std::string::size_type end,int level=0);
    virtual void parse_full() {
        if (parse_full_mode==true) {
            return;
        }
        parse_full_mode=true;
        this->parse(offset(),offset()+length());
    }

    // Returns the number of header fields parsed in the last invocation of parse().
    std::size_t field_count() const;

    virtual void add_header(const std::string &n, const std::string &v) {
        added_header_list.push_back(header_pair_t(n,v));
    }

    virtual void add_header(const std::string &n, const struct tm &time_tm) {
        char buf[64];
        size_t len = strftime(buf, sizeof(buf), "%a, %d %b %Y %H:%M:%S %z", &time_tm);
        added_header_list.push_back(header_pair_t(n, std::string(buf, len)));
    }

    virtual std::string added_headers() {
        std::string res;
        for (header_list_t::const_iterator i=added_header_list.begin(); i!=added_header_list.end(); i++) {
            res+=i->first;
            res+=": ";
            res+=i->second;
            res+='\n';
        }
        return res;
    }

    struct {
        std::string type;
        std::string subtype;
        std::string charset;
        std::string boundary;
        std::string name;
    } content_type;

    std::string content_transfer_encoding;

    struct {
        std::string value;
        std::string filename;
    } content_disposition;

    std::string content_id;

    rfc2822address *from;
    rfc2822address *to;
    rfc2822address *cc;

    std::string message_id;

    /*
      typedef std::multimap<std::string, std::string> header_map_t;
      typedef std::pair<std::string, std::string> header_pair_t;
      header_map_t header_map;
    */
    typedef std::pair<std::string, std::string> header_pair_t;
    typedef std::vector<header_pair_t> header_list_t;
    header_list_t header_list;
    header_list_t added_header_list;


protected:
    virtual bool handle_field(const std::string& name, const std::string::size_type beg, const std::string::size_type end);

private:
    void handle_content_id(const std::string::size_type beg, const std::string::size_type end);
    void handle_content_type(const std::string::size_type beg, const std::string::size_type end);
    void handle_content_disposition(const std::string::size_type beg, const std::string::size_type end);
    bool handle_mime_version(const std::string::size_type beg, const std::string::size_type end);
public:
    static std::string handle_decoded_string(const DecodedString& decodedString);

private:

    bool parse_full_mode;

    int  count_field;

};

};

#endif
