/**
 * @file
 * @deprecated
 */
// -*- C++ -*-
//

#ifndef MIME_PARAM_H
#define MIME_PARAM_H

//#include <mimeparser/config.h>
#include <map>
#include <algorithm>
#include <string>
#include <vector>
#include <ctype.h>



namespace mulca_mime {

inline bool
isspecial(int c)
{
    if (c == '(' || c==')' || c=='<' || c=='>' || c=='[' || c==']' ||
            c=='@' || c=='\\' || c==',' || c=='.' || c=='\"') {
        return true;
    }
    return false;
}

inline int
istspecial(int c)
{
    if (c == '(' || c==')' || c=='<' || c=='>' || c=='[' || c==']' ||
            c=='@' || c=='\\' || c==',' || c=='?' || c=='\"' ||c == '=' ||
            c == ';' || c == '/') {
        return true;
    }
    return false;
}

inline int
iscontrol(int c)
{
    if ((c > 0 && c < 9) || c == 11 || c==12 || c == 127 || (c > 13 && c < 32)) {
        return true;
    }
    return false;
}

struct lowercase {
    int operator()(const char c) const {
        return tolower(c);
    }
};

class tokens {
public:
    tokens(const std::string& b,size_t start_=0, size_t len=std::string::npos): buffer(b),start(start_) {
        if (len==std::string::npos) {
            end=buffer.length();
        } else {
            end=start+len;
        }
        parse_next_token();
    }
    enum token_type {
        error,
        eof,
        special,
        tspecial,
        token
    };
    token_type operator++(void) {
        return parse_next_token();
    }
    token_type operator++(int) {
        return parse_next_token();
    }
    token_type read_boundary(void) {  // read token assuming that it can contain "=".  jira #EML-2523
        return parse_next_token(true);
    }
    token_type type(void) {
        return current_token_type;
    }
    std::string val(void) {
        return current_token;
    }
private:
    const std::string& buffer;
    size_t start;
    size_t end;
    token_type current_token_type;
    std::string current_token;

    token_type parse_next_token(bool is_reading_boundary=false) {  // #EML-2523
        while (start<end) {
            current_token_type=eof;
            current_token="";
            while (isspace(buffer[start]) || iscontrol(buffer[start])) {
                start++;
                if (start>=end) {
                    return current_token_type;
                }
            };
            if (buffer[start]=='\"') {
                read_qs();
                start++;
                return current_token_type=token;
            } else if (buffer[start]=='(') {
                skip_cws();
                continue;
            } else if (istspecial(buffer[start])) {
                current_token=buffer[start++];
                return current_token_type=tspecial;
            } else {
                read_token(is_reading_boundary);       // #EML-2523
                return current_token_type=token;
            }
        }
        current_token="";
        return	current_token_type=eof;
    }
    void read_qs(void) {
        current_token="";
        if (buffer[start++]!='\"') {
            return;
        }
        while (start < end) {
            if (buffer[start]=='\\') {
                ++start;
                if (start >= end) {
                    return;
                }
            } else if (buffer[start] == '\"') {
                break;
            }
            current_token +=buffer[start];
            ++start;
        }
    }
    void skip_cws(void) {
        int comment = 0;
        while (start < end) {
            char c = buffer[start];
            if (c == '(') {
                comment = 1;
                ++start;
                while (comment && start < end) {
                    c=buffer[start++];
                    if (c == '\\' && start < end) {
                        ++start;
                    } else if (c == '(') {
                        ++comment;
                    } else if (c == ')') {
                        --comment;
                    }
                }
                --start;
            } else if (!isspace(c) && !iscontrol(c)) {
                break;
            }
            ++start;
        }
    }
    void read_token(bool accept_equals_sign=false) {  // #EML-2523
        current_token="";
        while (start < end) {
            if (isspace(buffer[start]) ||
                    iscontrol(buffer[start]) ||
                    istspecial(buffer[start])) {
                if (accept_equals_sign && '='==buffer[start]) { // #EML-2523
                    ;    // accept "="
                } else {
                    break;
                }
            }
            current_token +=buffer[start++];
        }
    }

};

class parameters {
public:
    typedef std::map<std::string,std::string> par_t;
    parameters(const std::string&b, size_t start=0, size_t len=std::string::npos): token_(),token2_(),
        tok(b,start,len) {
        parse();
    }
    std::string token(void) {
        return token_;
    }
    std::string token2(void) {
        return token2_;
    }
    bool exist(const std::string& name) {
        return par_list.find(name)!=par_list.end();
    }
    std::string operator[](const std::string& name) {
        if (exist(name)) {
            return par_list[name];
        }
        return std::string();
    }
    const par_t& operator()(void) {
        return par_list;
    }
private:
    std::string token_;
    std::string token2_;
    tokens tok;
    par_t par_list;
    inline void parse(void);
    void save(const std::string& n,const std::string& v) {
        par_list.insert(par_t::value_type(n,v));
    }
};

void
parameters::parse(void)
{
    std::string name,value;
    if (tok.type()!=tokens::token) {
        return;
    }
    token_=tok.val();
    tok++;
    if (tok.type()==tokens::tspecial && tok.val()[0]=='/') {
        tok++;
        if (tok.type()==tokens::token) {
            token2_=tok.val();
            tok++;
        }
    }
    while (tok.type()!=tokens::eof) {
        while ((tok.type()!=tokens::tspecial) || tok.val()[0]!=';') {
            if (tok.type()==tokens::eof) {
                return;
            }
            tok++;
        }
        name=value="";
        tok++;
        while (tok.type()!=tokens::token) {
            if (tok.type()==tokens::eof) {
                return;
            }
            tok++;
        }
        name=tok.val();
        std::transform(name.begin(),name.end(),name.begin(),mulca_mime::lowercase());
        tok++;
        if ((tok.type() == tokens::tspecial) && tok.val()[0]=='=') {
            if ("boundary"==name) { // assuming name being lowercase cause of std::transform // #EML-2523
                tok.read_boundary();
            } else {
                tok++;
            }
            while (tok.type()!=tokens::token) {
                if (tok.type()==tokens::eof) {
                    return;
                }
                tok++;
            }
            value=tok.val();
        }
        save(name,value);
        tok++;
    }
};


/// --------------------- paramters_ng --------------------- ///
// +added support for rfc2184

/// return 'value' with hex value of char c
inline bool get_hex_char(const unsigned char c, unsigned char& value)
{
    if (c>='0' && c<='9') {
        value=static_cast<unsigned char>(c-'0');
        return true;
    }
    if (c>='A' && c<='F') {
        value=static_cast<unsigned char>(c-'A'+10);
        return true;
    }
    if (c>='a' && c<='f') {
        value=static_cast<unsigned char>(c-'a'+10);
        return true;
    }
    return false;
}

/// calculate value of ext_octet (like 0F, FF, A3)
inline bool get_ext_octet(const unsigned char first, const unsigned char second, unsigned char& value)
{
    unsigned char first_value;
    unsigned char second_value;
    if (get_hex_char(first,first_value) && get_hex_char(second,second_value)) {
        value = static_cast<unsigned char>((first_value << 4) | second_value);
        return true;
    }
    return false;
}

/// contains charset and language.
struct DecodedString {
    DecodedString() : charset(),language(),contents(),num(0) {}
    DecodedString(std::string _charset,
                  std::string _language,
                  std::string _contents,
                  unsigned int _num) :
        charset(_charset),
        language(_language),
        contents(_contents),
        num(_num) {}
    void clear() {
        charset.clear();
        language.clear();
        contents.clear();
        num=0;
    }
    std::string charset;
    std::string language;
    std::string contents;
    // number in rfc2184
    unsigned int num;
};

typedef std::vector<std::string> HeaderList;

class parameters_ng {  // new generation with rfc2184 support
public:
    typedef std::map<std::string,DecodedString> par_t;
    parameters_ng(const std::string&b, size_t start=0, size_t len=std::string::npos, HeaderList rawHeaders=HeaderList()): token_(),token2_(),
        tok(b,start,len), rawHeaders_(rawHeaders) {
        parse();
    }
    std::string token(void) {
        return token_;
    }
    std::string token2(void) {
        return token2_;
    }
    bool exist(const std::string& name) {
        return par_list.find(name)!=par_list.end();
    }
    DecodedString operator[](const std::string& name) {
        if (exist(name)) {
            return par_list[name];
        }
        return DecodedString();
    }
    const par_t& operator()(void) {
        return par_list;
    }
private:
    std::string token_;
    std::string token2_;
    tokens tok;
    par_t par_list;
    HeaderList rawHeaders_;
    /// parse all parameters
    inline void parse();
    /// read 'type/subtype', stand on ';'
    inline bool read_content_header();
    /// read token name : <name>[\*part_num][\*]=  (support for rfc2184)
    inline bool read_name(std::string& name, unsigned int& part_num, bool& is_encoded);
    /// read value - it is concatenation of all tokens before ';' or tokens::eof
    inline bool read_value(DecodedString& decodedString, const unsigned int part_num, const bool is_encoded);
    /// save parameter into container.
    void save(const std::string& name, const DecodedString& value) {
        if (exist(name)) {
            // add new part of parameter
            if (value.num==par_list[name].num+1) {
                par_list[name].contents+=value.contents;
                ++par_list[name].num;
            }
        } else {
            // add new parameter
            par_list.insert(par_t::value_type(name,value));
        }
    }
};

inline bool parameters_ng::read_content_header()
{
    if (tokens::token!=tok.type()) {
        return false;
    }
    token_=tok.val();
    tok++;
    if (tokens::tspecial==tok.type() && '/'==tok.val()[0]) {
        tok++;
        if (tokens::token==tok.type()) {
            token2_=tok.val();
            tok++;
        }
    }
    return true;
}

inline bool parameters_ng::read_name(std::string& name, unsigned int& part_num,
                                     bool& is_encoded)
{
    name.clear();
    part_num=0;
    is_encoded=false;
    tok++;  // reading name
    if (tokens::token!=tok.type()) {
        return false;
    }
    name=tok.val();
    if (name.empty()) {
        return false;
    }
    tok++;  // reading '='
    if (tokens::tspecial==tok.type() && '='==tok.val()[0]) {
        const std::string::size_type first_asterisk=name.find('*');
        if (first_asterisk==std::string::npos) {
            return true;
        }
        if (0==first_asterisk) {
            return false;
        }
        const std::string name_suffix=name.substr(first_asterisk);
        name.resize(first_asterisk); // here we have the name
        if ('*'==name_suffix[name_suffix.length()-1]) {
            if (std::find(rawHeaders_.begin(), rawHeaders_.end(), name)==rawHeaders_.end()) {
                is_encoded=true;
            }
        }
        if (1==name_suffix.length()) {
            return true;
        } else if (1<name_suffix.length()) {
            part_num=atoi(name_suffix.substr(1).c_str());
            return true;
        }
    }
    return false;
}

inline bool parameters_ng::read_value(DecodedString& decodedString,
                                      const unsigned int part_num, const bool is_encoded)
{
    std::string str;
    decodedString.clear();
    tok++;
    // trying to read tokens until ; or until eof.
    while (tokens::eof!=tok.type() && ';'!=tok.val()[0]) {
        str+=tok.val();
        tok++;
    }
    if (str.empty()) {
        return true;    // to be compatible with prev. version
    }
    decodedString.num=part_num;
    if (is_encoded) {
        std::string::size_type pos=0;
        if (0==part_num) { // trying to read encoding and language;
            const std::string::size_type first_amp=str.find('\'',pos);
            if (first_amp!=std::string::npos && first_amp+1<str.length()) {
                const std::string::size_type second_amp=str.find('\'',first_amp+1);
                if (second_amp!=std::string::npos && second_amp<str.length()) {
                    if (first_amp>pos) {
                        decodedString.charset=str.substr(pos,first_amp-pos);
                    }
                    if (second_amp>first_amp+1) {
                        decodedString.language=
                            str.substr(first_amp+1,second_amp-first_amp-1);
                    }
                    pos=second_amp+1;
                }
            }
        }
        // here we already read charset and language, and now ready to read value
        while (pos<str.length()) {
            if ('%'==str[pos]) {
                if (pos+2<str.length()) {
                    unsigned char value;
                    if (get_ext_octet(str[pos+1],str[pos+2],value)) {
                        decodedString.contents+=static_cast<char>(value);
                        pos+=3;
                    } else {
                        decodedString.contents+=str[pos];
                        ++pos;
                    }
                } else {
                    decodedString.contents+=str.substr(pos);
                    return true;
                }
            } else {
                decodedString.contents+=str[pos];
                ++pos;
            }
        }
    } else {  // if not encoded.
        decodedString.contents=str;
    }
    return true;
}


void parameters_ng::parse()
{
    if (!read_content_header()) {
        return;
    }
    while (tok.type()!=tokens::eof) {
        std::string name;
        DecodedString value;
        unsigned int part_num=0;
        bool is_encoded=false;
        if (read_name(name,part_num,is_encoded) && read_value(value,part_num,is_encoded)) {
            std::transform(name.begin(),name.end(),name.begin(),mulca_mime::lowercase());
            save(name,value);
        } else {
            // we run to find beggining of new parameter (';'parameter)
            while (tokens::eof!=tok.type() && ';'!=tok.val()[0]) {
                tok++;
            }
        }
    }
}




};



#endif
