#ifndef MIME_PART_H
#define MIME_PART_H

//#include <mimeparser/config.h>
#include <list>

#include <mimeparser/component.h>
#include <mimeparser/header.h>
#include <mimeparser/body.h>
#include <cstddef>

namespace mulca_mime {
class part;
typedef std::list<part> parts_t;

class part : public component {
public:
    part(const std::string& msg, part* parent_) : component(msg), parent(parent_), id(""), header(msg), body(msg) {};
    virtual ~part();

    virtual std::string::size_type parse(int _inlineLevel, const std::string::size_type beg, const std::string::size_type end,int level=0);
    virtual std::string::size_type parse(const std::string::size_type beg, const std::string::size_type end,int level=0);

    part* parent;
    std::string id; // Warning!! id is not present when parsing MIME.
    parts_t parts;
    mulca_mime::header header;
    mulca_mime::body body;
    int inlineLevel;
    static const size_t max_part = 500;

    void dump(std::ostream& o, const std::string& id_prefix, unsigned int pos = 1, unsigned int level = 0) const;
    void dump(std::string& o, const std::string& id_prefix, unsigned int pos = 1, unsigned int level = 0) const;

    virtual std::string fake_assemble() {
        return header.added_headers()+header.asString()+asString();
    }

    struct iterator;

    iterator begin() {
        return iterator(this);
    }
    iterator end() {
        return iterator(0);
    }

    /// Iterator starts with xml offset
    struct iterator {
        typedef part value_type;
        typedef part&  reference;
        typedef part*  pointer;

        typedef ptrdiff_t difference_type;
        typedef std::forward_iterator_tag iterator_category;


        iterator() : node(0) {}
        iterator(part* n) : node(n) {}

        bool operator==(const iterator& rhs) const {
            return node == rhs.node;
        }
        bool operator!=(const iterator& rhs) const {
            return node != rhs.node;
        }

        part* operator->() {
            return node;
        };
        part& operator*() {
            return *node;
        };

        iterator operator++() {
            if (node->parts.begin() != node->parts.end()) {
                //node = node->parts.begin();
                node = &(*(node->parts.begin()));
                return *this;
            }
            while (true) {
                part * p = node->parent;
                if (p==0) {
                    node = 0;
                    return *this;
                }
                parts_t::iterator n = p->parts.begin();
                parts_t::iterator end = p->parts.end();
                //while((n!=end) && (n != node))
                while ((n!=end) && ((&(*n)) != node)) {
                    ++n;
                }
                if (n==end) {
                    // ASSERT
                    node = 0;
                    return *this;
                }
                ++n;
                if (n==end) {
                    node = p;
                } else {
                    //node = n;
                    node = &(*n);
                    return *this;
                }
            }
            return *this;
        }

        part* node;
    };

private:
    struct parse_data;
    std::string::size_type do_parse(const parse_data& d);

};

std::ostream& operator<<(std::ostream& o, const part& p);
void part_str(std::string& o,const part& p);

} // namespace mulca_mime

#endif
