#ifndef BUTIL_QP
#define BUTIL_QP

#include <cstddef>
#include <boost/range/iterator_range.hpp>

/**
 * @file
 *
 * @todo add cc
 *
 * Here some links and implementation related to quoted-printable encoding
 * http://en.wikipedia.org/wiki/Quoted-printable
 */

namespace mail { namespace utils { namespace qp {

    class traits {
        public:
            static const char EQUALS_SIGN='=';
    };

    /**
     *  Calculate length of right-encoded in qp.
     *
     *  @todo Fix issue with \n instead of \r\n
     *  @todo Need to report on error in case of it
     */
    template <class Iterator>
    size_t calculate_length(const boost::iterator_range<Iterator> range) {
        size_t result=0;
        Iterator it=range.begin();
        while (it!=range.end()) {
            if (traits::EQUALS_SIGN!=*it) {
                ++result;
            } else {
                if (it+1!=range.end()) {
                    ++it;
                    if ('\r'==*it) {
                        if (it+1!=range.end()) {
                            if ('\n'==*(it+1)) {
                                ++it;
                            }
                        }
                    } else if ('\n'==*it) {
                    } else {
                        ++it;
                        ++result;
                    }
                }
                /*
                ++result;
                // no undefined behavior - lazy logic
                if ((++it)==range.end() || (++it)==range.end()) {
                    break;
                }
                */
            }
            ++it;
        }
        return result;
    }

    template <class Iterator>
    class LengthCalculator {
        public:
            typedef enum {
                NO_EQUALS,
                HAS_EQUALS_CHAR_0,
                HAS_EQUALS_CHAR_1_SYMBOL,
                HAS_EQUALS_CHAR_1_SLASHR
            } State;
        public:
            LengthCalculator()
            : m_state(NO_EQUALS)
            , m_length(0)
            {}
            void push(const Iterator& begin, const Iterator& end) {
                for (Iterator it=begin; it!=end; ++it) {
                    pushChar(*it);
                }
            }
            void stop() {
                /*NO-OP, but we can check for error here*/
            }
            bool isCorrect() const {
                return true;
            }
            size_t length() const {
                return m_length;
            }
        private:
            inline void pushChar(char c) {
                switch (m_state) {
                    case NO_EQUALS: {
                        if (traits::EQUALS_SIGN!=c) {
                            ++m_length;
                        } else {
                            m_state=HAS_EQUALS_CHAR_0;
                        }
                    } break;
                    case HAS_EQUALS_CHAR_0: {
                        if ('\n'==c) {
                            m_state=NO_EQUALS;
                        } else if ('\r'==c) {
                            m_state=HAS_EQUALS_CHAR_1_SLASHR;
                        } else {
                            m_state=HAS_EQUALS_CHAR_1_SYMBOL;
                        }
                    } break;
                    case HAS_EQUALS_CHAR_1_SLASHR : {
                        if ('\n'==c) {
                            m_state=NO_EQUALS;
                        } else {
                            m_length+=2;
                            m_state=NO_EQUALS;
                        }
                    } break;
                    case HAS_EQUALS_CHAR_1_SYMBOL: {
                        ++m_length;
                        m_state=NO_EQUALS;
                    } break;
                }
            }
        private:
            State m_state;
            size_t m_length;
    };

} // namespace qp
} // namespace utils
} // namespace mail


#endif
