#ifndef RFC2047_H
#define RFC2047_H

//#include <mimeparser/config.h>
#include <string>
#include <vector>

namespace mulca_mime {
std::string
decode_rfc2047(const std::string& src, std::string &charset);

/*
 *  Representation of  "encoded-word" or just of plain text (in that case charset="")
 */
struct EncodedWord {
    EncodedWord() :
        charset(),word() {}
    EncodedWord(const std::string& _charset, const std::string& _word) :
        charset(_charset), word(_word) {}
    void clear() {
        charset.clear();
        word.clear();
    }
    void set(const std::string& _charset, const std::string& _word) {
        charset=_charset;
        word=_word;
    }
    std::string charset;
    std::string word;
};

/**
 * Function returns vector of EncodedWord's.
 * This function will be useful, if there are "encoded-words" with different
 * charsets.
 * In each EncodedWord : member "charset" is charset of member "word"
 * It written to fix EML-3421.
 * Returned vector contains at least one element.
 */
std::vector<EncodedWord>
decode_rfc2047(const std::string& src);
};

#endif
