#ifndef RFC2822ADDRESS_H
#define RFC2822ADDRESS_H

//#include <mimeparser/config.h>
#include <string>
#include <list>

namespace rfc2822 {

using std::pair;
using std::list;
using std::string;

typedef pair<string,string> address_pair_t;
typedef list<address_pair_t> address_list_t;

std::string unquote(const std::string& str);

class old_rfc2822address: public address_list_t {
public:
    old_rfc2822address(const string &addr): status_(false) {
        parse(addr);
    }
    bool ok() {
        return status_;
    }
    const string& group_name(void) const {
        return gr_name_;
    }
private:
    void parse(const string&);
    bool status_;
    string gr_name_;
};

class rfc2822address: public address_list_t {
public:
    rfc2822address(const string &addr): status_(false) {
        parse(addr);
    }
    bool ok() {
        return status_;
    }
private:
    void parse(const string&);
    void parse_fallback(const string&);
    bool status_;
};


};
#endif
