#ifndef STRTOOLS_H
#define STRTOOLS_H

//#include <mimeparser/config.h>
#include <stdio.h>
#include <string>

static const int  MAX_DIG=40;

static const char alpha[16]= {
    '0','1','2','3','4','5','6',
    '7','8','9','a','b','c','d',
    'e','f'
};

inline char *
gitoa(int val ,char *b1,int len, int base)
{
    b1++; // Space for sign.
    // Pointer to end of string.
    char *ep=b1+len-2;
    *ep='\0';
    // Sign indicator.
    int neg=val;
    if (val<0) {
        val = val*(-1);
    }
    do {
        *--ep =alpha[val % base];
        val = val/base;
    } while (val!=0 && b1!=ep);
    if (neg<0) {
        *--ep='-';
    }
    return ep;
}

inline char *
lgitoa(long long int val ,char *b1,int len, int base)
{
    b1++; // Space for sign.
    // Pointer to end of string.
    char *ep=b1+len-2;
    *ep='\0';
    // Sign indicator.
    int neg=val;
    if (val<0) {
        val = val*(-1);
    }
    do {
        *--ep =alpha[val % base];
        val = val/base;
    } while (val!=0 && b1!=ep);
    if (neg<0) {
        *--ep='-';
    }
    return ep;
}


inline char *
utoa(unsigned long int val ,char *b1,int len, unsigned int base)
{
    // Pointer to end of string.
    char *ep=b1+len-1;
    *ep='\0';
    do {
        *--ep =alpha[val % base];
        val = val/base;
    } while (val!=0 && b1!=ep);
    return ep;
}

inline char *
lutoa(unsigned long long int val ,char *b1,int len, unsigned int base)
{
    // Pointer to end of string.
    char *ep=b1+len-1;
    *ep='\0';
    do {
        *--ep =alpha[val % base];
        val = val/base;
    } while (val!=0 && b1!=ep);
    return ep;
}


inline char*  dc(int a,char* b, int l)
{
    return gitoa(a,b,l,10);
}

inline char*  ldc(long long int a,char* b, int l)
{
    return lgitoa(a,b,l,10);
}

// XX change int to unsigned
inline char*  udc(unsigned int a,char* b, int l)
{
    return utoa(a,b,l,10);
}

inline char*  ludc(unsigned long long int a,char* b, int l)
{
    return lutoa(a,b,l,10);
}


inline std::string
itoa(int i)
{
    char buff[MAX_DIG];
    return std::string(dc(i,buff,sizeof(buff)));
}

inline std::string
itoa(unsigned i)
{
    char buff[MAX_DIG];
    return std::string(udc(i,buff,sizeof(buff)));
}

static const int cs_diff='A'-'a';

inline int
a_tolower(int c)
{
    return (c>='A' && c<='Z')?(c-cs_diff):c;
}

inline bool
a_islower(int c)
{
    return (c>='a' && c<='z');
}

inline int
a_isupper(int c)
{
    return (c>='A' && c<='Z');
}

inline int
a_isdigit(int c)
{
    return (c>='0' && c<='9');
}


inline int
a_isspace(int c)
{
    return (c==' ' || c=='\t' || c=='\r' || c=='\f' || c=='\n' || c=='\n');
}




inline int
a_isxdigit(int c)
{
    int k=a_tolower(c);
    return a_isdigit(c) || (k>='a' && k<='f');
}

inline int
a_isalnum(int c)
{
    int k=a_tolower(c);
    return a_isdigit(c) || (k>='a' && k<='z');
}



inline std::string
tolow(const std::string &s)
{
    std::string r(s.length(),'\0');
    for (std::string::size_type i=0; i<s.length(); ++i) {
        r[i]=a_tolower(s[i]);
    }
    return r;
}


static const char hexchars[] = "0123456789ABCDEF";

inline std::string
encode_url(const std::string& s, const char* skip_chars = "_-.")
{
    int x, y,len=s.length();
    std::string str;
    for (x = 0, y = 0; len--; x++, y++) {
        str += (unsigned char) s[x];
        if (str[y] == ' ') {
            str[y] = '+';
        } else if (!a_isalnum(str[y])
                   && strchr(skip_chars, str[y]) == 0) {
            /* Allow only alphanumeric chars and '_', '-', '.'; escape the rest */
            str[y]= '%';
            str  += hexchars[(unsigned char) s[x] >> 4];
            ++y;
            str  += hexchars[(unsigned char) s[x] & 0x0F];
            ++y;
        }
    }
    fprintf(stderr, "%s\n", str.c_str());
    return str;
}

inline unsigned
str_span(const std::string& line,unsigned& pos,const char* wh)
{
    if (pos<line.length()) {
        pos+=strspn(line.c_str()+pos,wh);
    }
    return pos;
}

#endif
