#pragma once

#include <boost/iterator/filter_iterator.hpp>
#include <functional>

/// @todo FIXME check is iterator is working correctly

namespace MimeParser {

using boost::filter_iterator;

/// @todo move out from here
struct IsEolCharacter {
    bool operator()(char c) const {
        return '\n'==c || '\r'==c;
    }
};
using NotEolCharacter = decltype(std::not_fn(IsEolCharacter{}));

template <class Iterator>
struct Unfold {
    typedef filter_iterator<NotEolCharacter, Iterator> iterator;

    static
    iterator
    create(const Iterator& begin, const Iterator& end) {
        return iterator(std::not_fn(IsEolCharacter()), begin, end);
    }
};
}
