include(find_mimeparser_dependencies)

if(MIMEPARSER_FOUND)
  set(MIMEPARSER_FIND_QUIETLY TRUE)
endif()

find_path(MIMEPARSER_INCLUDE_DIR
  NAMES mimeparser/api.h
  HINTS ${CMAKE_INSTALL_PREFIX}/include)

find_library(MIMEPARSER_LIBRARY
  NAMES mimeparser
  HINTS ${CMAKE_INSTALL_PREFIX}
  PATH_SUFFIXES .libs lib lib64)

find_mimeparser_dependencies()

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(MIMEPARSER DEFAULT_MSG
  MIMEPARSER_INCLUDE_DIR MIMEPARSER_LIBRARY)

if(MIMEPARSER_FOUND)
  list(APPEND MIMEPARSER_INCLUDE_DIR ${MIMEPARSER_DEPENDENCY_INCLUDE_DIRS})
  list(APPEND MIMEPARSER_LIBRARIES ${MIMEPARSER_LIBRARY} ${MIMEPARSER_DEPENDENCY_LIBRARIES})
endif()

mark_as_advanced(MIMEPARSER_INCLUDE_DIR MIMEPARSER_LIBRARIES)
