#include <mimeparser/Hid.h>
#include <boost/lexical_cast.hpp>

#include <stdexcept>

#include <cstdlib>

using namespace MimeParser;
using std::string;

Hid::
Hid(const string& str)
{
    parseHid(str);
}

void
Hid::
parseHid(const string& str)
{
    m_hid.clear();
    string::size_type pos=0;
    string::size_type nextDot;
    do {
        nextDot=str.find('.', pos);
        if (pos==nextDot) {
            throw std::runtime_error("Invalid hid");
        }
        int localPartNumber=atoi(str.c_str()+pos);
        if (localPartNumber<=0) {
            throw std::runtime_error("Invalid local number: must be positive.");
        }
        m_hid.push_back(static_cast<PartNumber>(localPartNumber));
        pos=nextDot+1;
    } while (string::npos!=nextDot);
}

size_t
Hid::
depth() const
{
    return m_hid.size();
}

Hid::
PartNumber
Hid::
length() const
{
    return m_hid.back();
}

void
Hid::
next()
{
    ++m_hid.back();
}

void
Hid::
advance(int delta)
{
    m_hid.back()+=delta;
}


void
Hid::
stepDown()
{
    m_hid.push_back(1);
}

void
Hid::
stepUp()
{
    m_hid.pop_back();
}

string
Hid::
toString() const
{
    std::string result;
    for (HeaderId::size_type i=0; i<m_hid.size()-1; ++i) {
        result+=boost::lexical_cast<std::string>(m_hid[i])+'.';
    }
    result+=boost::lexical_cast<std::string>(m_hid.back());
    return result;
}

