#include <mimeparser/Mulca.h>

std::string
MimeParser::Mulca::
parse_message(const std::string& message, StringHeaderHandlerFactory headerHandlerFactory)
{
    return parse_range(message.begin(), message.end(), headerHandlerFactory);
}

std::string
MimeParser::Mulca::
parse_message(
    const std::string& message
,   Handlers::MessageHandler<std::string::const_iterator>::ErrorList& errors
,   StringHeaderHandlerFactory headerHandlerFactory)
{
    return parse_range(message.begin(), message.end(), errors, headerHandlerFactory);
}
