#include <iostream>
#include <mimeparser/encoding.h>

namespace mulca_mime {
size_t base64_decoded_size(const char *data, size_t length)
{
    size_t size = length;
    const char *data_ptr = data, *data_end_ptr = data + length;
    for (; data_ptr < data_end_ptr && size > 0; data_ptr++) {
        if (*data_ptr == '\r' || *data_ptr == '\n') {
            size--;
        }
    }
    // get rid of final CRLF
    for (--data_end_ptr; data_end_ptr > data && size > 0 && length > 0; data_end_ptr--) {
        if (*data_end_ptr == '\r' || *data_end_ptr == '\n') {
            length--;
        } else {
            break;
        }
    }
    size = (size / 4) * 3;
    if (length > 2 && *(data + length - 2) == '=' && size >= 2) {
        size -= 2;
    } else if (size > 0 && *(data + length - 1) == '=') {
        size--;
    }
    return size;
}

size_t qp_decoded_size(const char *data, size_t length)
{
    size_t size = 0;
    const char *data_end_ptr = data + length;
    while (data < data_end_ptr)
        if (*data == '=') {
            if (*(data + 1) != '\r' && *(data + 1) != '\n') {
                size++;
                data += 3;
            } else if (*(data + 1) == '\r' && *(data + 2) == '\n') {
                data += 3;
            } else {
                data += 2;
            }
        } else {
            size++;
            data++;
        }
    return size;
}
}
