/**
 * @file
 * @deprecated
 */
#include <iostream>
#include <mimeparser/header.h>
#include <mimeparser/ccnv.h>
#include <mimeparser/rfc2047.h>


#define MAX_HEADER_FIELDS 200

namespace mulca_mime {

header::~header()
{
    delete cc;
    delete to;
    delete from;
};

std::size_t header::field_count() const
{
    return MAX_HEADER_FIELDS - count_field;
}
std::string::size_type
header::parse(int, const std::string::size_type beg, const std::string::size_type end,int)
{
    std::string::size_type pos = beg;
    count_field = MAX_HEADER_FIELDS;
    while (pos < end) {
        char c = buffer[pos];
        // Check for end of headers (empty line): although RFC-822 recommends
        // to use CRLF for header/body separator (see 4.1 SYNTAX), here, we
        // also check for LF just in case...
        if (c == '\n') {
            ++pos;
            break;
        } else if (c == '\r' && pos + 1 < end && buffer[pos + 1] == '\n') {
            pos += 2;
            break;
        }
        // This line may be a field description
        if (!isspace(c)) {
            const std::string::size_type nameStart = pos;  // remember the start position of the line
            while (pos < end && (buffer[pos] != ':' && !isspace(buffer[pos]))) {
                ++pos;
            }
            const std::string::size_type nameEnd = pos;
            while (pos < end && isspace(buffer[pos])) {
                ++pos;
            }
            if (buffer[pos] != ':') {
                // Humm...does not seem to be a valid header line.
                // Skip this error and advance to the next line
                pos = nameStart;
                while (pos < end && buffer[pos] != '\n') {
                    ++pos;
                }
                if (buffer[pos] == '\n') {
                    ++pos;
                }
            } else {
                // Extract the field name
                const std::string name(buffer.begin() + nameStart,
                                       buffer.begin() + nameEnd);
                // Skip ':' character
                ++pos;
                // Skip spaces between ':' and the field contents
                while (pos < end && (buffer[pos] == ' ' || buffer[pos] == '\t')) {
                    ++pos;
                }
                // Extract the field value
                std::string contents;
                const std::string::size_type ctsStart = pos;
                std::string::size_type ctsEnd = pos;
                while (pos < end) {
                    c = buffer[pos];
                    // Check for end of contents
                    if (c == '\r' && pos + 1 < end && buffer[pos + 1] == '\n') {
                        pos += 2;
                        break;
                    } else if (c == '\n') {
                        ++pos;
                        break;
                    }
                    ctsEnd = pos;
                    while (pos < end) {
                        c = buffer[pos];
                        // Check for end of line
                        if (c == '\r' && pos + 1 < end && buffer[pos + 1] == '\n') {
                            ctsEnd = pos;
                            pos += 2;
                            break;
                        } else if (c == '\n') {
                            ctsEnd = pos;
                            ++pos;
                            break;
                        }
                        ++pos;
                    }
                    // Handle the case of folded lines
                    if (buffer[pos] == ' ' || buffer[pos] == '\t') {
                        // This is a folding white-space: we keep it as is and
                        // we continue with contents parsing...
                    } else {
                        // End of this field
                        break;
                    }
                }
                // Deal with invalid messages whose header lines end with \r\r+\n.
                while (ctsStart != ctsEnd
                        && buffer[ctsEnd-1] == '\r') {
                    ctsEnd--;
                }
                if (!handle_field(name, ctsStart, ctsEnd)) {
                    return end;
                }
            }
        } else {
            // Skip this error and advance to the next line
            while (pos < end && buffer[pos] != '\n') {
                ++pos;
            }
            if (buffer[pos] == '\n') {
                ++pos;
            }
        }
    }
    if (pos>end) { // No empty line.
        pos=end;
    }
    offset()=beg;
    length()=pos-offset();
    return pos;
}

std::string::size_type
header::parse(const std::string::size_type beg, const std::string::size_type end,int)
{
    std::string::size_type pos = beg;
    count_field = MAX_HEADER_FIELDS;
    while (pos < end) {
        char c = buffer[pos];
        // Check for end of headers (empty line): although RFC-822 recommends
        // to use CRLF for header/body separator (see 4.1 SYNTAX), here, we
        // also check for LF just in case...
        if (c == '\n') {
            ++pos;
            break;
        } else if (c == '\r' && pos + 1 < end && buffer[pos + 1] == '\n') {
            pos += 2;
            break;
        }
        // This line may be a field description
        if (!isspace(c)) {
            const std::string::size_type nameStart = pos;  // remember the start position of the line
            while (pos < end && (buffer[pos] != ':' && !isspace(buffer[pos]))) {
                ++pos;
            }
            const std::string::size_type nameEnd = pos;
            while (pos < end && isspace(buffer[pos])) {
                ++pos;
            }
            if (buffer[pos] != ':') {
                // Humm...does not seem to be a valid header line.
                // Skip this error and advance to the next line
                pos = nameStart;
                while (pos < end && buffer[pos] != '\n') {
                    ++pos;
                }
                if (buffer[pos] == '\n') {
                    ++pos;
                }
            } else {
                // Extract the field name
                const std::string name(buffer.begin() + nameStart,
                                       buffer.begin() + nameEnd);
                // Skip ':' character
                ++pos;
                // Skip spaces between ':' and the field contents
                while (pos < end && (buffer[pos] == ' ' || buffer[pos] == '\t')) {
                    ++pos;
                }
                // Extract the field value
                std::string contents;
                std::string::size_type ctsStart = pos;
                std::string::size_type ctsEnd = pos;
                bool firstTime=true;  // in case of folded lines, if not first time looping.
                while (pos < end) {
                    c = buffer[pos];
                    // Check for end of contents
                    if (c == '\r' && pos + 1 < end && buffer[pos + 1] == '\n') {
                        pos += 2;
                        // Folded line
                        if (!firstTime) {
                            break;
                        }
                        if (!(buffer[pos] == ' ' || buffer[pos] == '\t')) {
                            break;
                        }
                        while (pos < end && (buffer[pos] == ' ' || buffer[pos] == '\t')) {
                            ++pos;    // skip spaces
                        }
                        ctsStart=pos;
                    } else if (c == '\n') {
                        ++pos;
                        // Folded line
                        if (!firstTime) {
                            break;
                        }
                        if (!(buffer[pos] == ' ' || buffer[pos] == '\t')) {
                            break;
                        }
                        while (pos < end && (buffer[pos] == ' ' || buffer[pos] == '\t')) {
                            ++pos;    // skip spaces
                        }
                        ctsStart=pos;
                    }
                    ctsEnd = pos;
                    while (pos < end) {
                        c = buffer[pos];
                        // Check for end of line
                        if (c == '\r' && pos + 1 < end && buffer[pos + 1] == '\n') {
                            ctsEnd = pos;
                            pos += 2;
                            break;
                        } else if (c == '\n') {
                            ctsEnd = pos;
                            ++pos;
                            break;
                        }
                        ++pos;
                    }
                    // Handle the case of folded lines
                    if (buffer[pos] == ' ' || buffer[pos] == '\t') {
                        // This is a folding white-space: we keep it as is and
                        // we continue with contents parsing...
                    } else {
                        // End of this field
                        break;
                    }
                    firstTime=false;
                }
                // Deal with invalid messages whose header lines end with \r\r+\n.
                while (ctsStart != ctsEnd
                        && buffer[ctsEnd-1] == '\r') {
                    ctsEnd--;
                }
                if (!handle_field(name, ctsStart, ctsEnd)) {
                    return end;
                }
            }
        } else {
            // Skip this error and advance to the next line
            while (pos < end && buffer[pos] != '\n') {
                ++pos;
            }
            if (buffer[pos] == '\n') {
                ++pos;
            }
        }
    }
    if (pos>end) { // No empty line.
        pos=end;
    }
    offset()=beg;
    length()=pos-offset();
    return pos;
}


#define CHECK_FIELD(field, pattern) (field.length() == sizeof(pattern)-1) && (0 == strncasecmp(field.c_str(), pattern, sizeof(pattern)-1))

bool
header::handle_field(const std::string& name, const std::string::size_type beg, const std::string::size_type end)
{
    if (0>count_field) {
        return true;
    } else {
        --count_field;
    }
    char c = name[0];
    switch (c) {
        case 'C':
        case 'c':
            if (CHECK_FIELD(name, "content-type")) {
                handle_content_type(beg, end);
            } else if (CHECK_FIELD(name,"content-transfer-encoding")) {
                content_transfer_encoding.assign(buffer.begin()+beg, buffer.begin()+end);
            } else if (CHECK_FIELD(name,"content-disposition")) {
                handle_content_disposition(beg, end);
            } else if (CHECK_FIELD(name,"content-id")) {
                handle_content_id(beg, end);
            }
            break;
        default:
            break;
    }
    if (parse_full_mode) {
        switch (c) {
            case 'F':
            case 'f':
                if (CHECK_FIELD(name,"from")) {
                    delete from;
                    from=0;
                    from=new rfc2822address(buffer.substr(beg,end-beg));
                }
                break;
            case 'T':
            case 't':
                if (CHECK_FIELD(name,"to")) {
                    delete to;
                    to=0;
                    to=new rfc2822address(buffer.substr(beg,end-beg));
                }
                break;
            case 'C':
            case 'c':
                if (CHECK_FIELD(name,"cc")) {
                    delete cc;
                    cc=0;
                    cc=new rfc2822address(buffer.substr(beg,end-beg));
                }
                break;
            case 'M':
            case 'm':
                if (CHECK_FIELD(name,"message-id")) {
                    message_id=buffer.substr(beg,end-beg);
                }
                break;
            default:
                break;
        }
        header_list.push_back(header_pair_t(name,buffer.substr(beg,end-beg)));
    }
    return true;
}

void header::handle_content_id(const std::string::size_type beg,
                               const std::string::size_type end)
{
    size_t start=beg;
    while (start<end) {
        if (!isspace(buffer[start])) {
            break;
        }
        ++start;
    }
    if (start>=end) {
        return;
    }
    if (buffer[start]=='<') {
        ++start;
        // return; XXX handle errors
    }
    size_t id_start=start;
    while (start<end) {
        if (buffer[start]=='>' || isspace(buffer[start])) {
            break;
        }
        ++start;
    }
    if (id_start<end) {
        content_id.assign(buffer.begin()+id_start, buffer.begin()+start);
    }
}

void header::handle_content_type(const std::string::size_type beg,
                                 const std::string::size_type end)
{
    parameters_ng ct(buffer,beg,end-beg);
    if (!ct.token().empty()) {
        content_type.type.assign(ct.token());
        if (!ct.token2().empty()) {
            content_type.subtype.assign(ct.token2());
        }
    }
    if (ct.exist("charset")) {
        content_type.charset.assign(ct["charset"].contents);
    }
    if (ct.exist("boundary")) {
        content_type.boundary.assign(ct["boundary"].contents);
    }
    if (ct.exist("name")) {
        content_type.name.assign(handle_decoded_string(ct["name"]));
    }
}

void header::handle_content_disposition(const std::string::size_type beg,
                                        const std::string::size_type end)
{
    parameters_ng cd(buffer,beg,end-beg);
    if (!cd.token().empty()) {
        content_disposition.value.assign(cd.token());
    }
    if (cd.exist("filename")) {
        content_disposition.filename.assign(
            handle_decoded_string(cd["filename"])
        );
    }
}

/// decoding decodedString to std::string using convert.
std::string header::handle_decoded_string(const DecodedString& decodedString)
{
    std::string result;
    if (decodedString.contents.empty()) {
        return result;
    }
    if (decodedString.charset.empty()) {
        const std::vector<EncodedWord> encodedWords =
            decode_rfc2047(decodedString.contents);
        for (size_t i=0; i<encodedWords.size(); ++i) {
            if (!encodedWords[i].word.empty()) {
                const char* charset = encodedWords[i].charset.c_str();
                bool is_utf8_charset =
                    (0 == strncasecmp(charset,"utf-8", 5));
                std::string word = encodedWords[i].word;
                if (!is_utf8_charset && !encodedWords[i].charset.empty()) {
                    convert(charset,"utf-8").doit(word, word);
                }
                result += word;
            }
        }
    } else {
        result=decodedString.contents;
        convert(decodedString.charset.c_str(), "utf-8").doit(result, result);
    }
    return decode_numbered_entities(result);
}

} // namespace mulca_mime
