/*
 * $Id$
 *
 * $Log$
 * Revision 1.2  2006/10/24 13:50:39  virtan
 * rfc2822* moved to mimeparser
 *
 * Revision 1.1.1.1  2005/05/27 16:27:29  virtan
 * Mimeparser. Taken fron mod_mulca. Under autotools.
 *
 * Revision 1.9  2005/02/15 08:36:15  alg
 * libxml cyrillic charset fixes
 *
 * Revision 1.8  2004/10/21 15:50:54  alg
 * make libxml error messages more inform.
 *
 * Revision 1.7  2004/09/24 14:17:47  alg
 * Error friendly mime parser and xml part list structure
 *
 * Revision 1.6  2004/07/09 13:22:40  bacek
 * "Warnings" fixed
 *
 * Revision 1.5  2004/07/01 11:56:27  bacek
 * Add returning of xml.
 *
 * Revision 1.4  2004/07/01 10:56:05  bacek
 * Use iterators in get_part
 *
 * Revision 1.3  2004/07/01 09:43:53  bacek
 * Get part is works now!
 *
 * Revision 1.2  2004/07/01 08:02:29  bacek
 * Yes! It works!
 *
 * Revision 1.1  2004/06/30 17:05:07  bacek
 * First prototype of xml parsing facility.
 *
 */

#include <iostream>
#include <memory>
#include <boost/lexical_cast.hpp>
#include <libxml/xmlreader.h>
#include <mimeparser/libxml_helpers.h>
#include <cstring>
#include <mimeparser/xml_parse.h>

namespace libxml {
template<>
struct xml_traits<xmlTextReaderPtr> {
    static void delete_data(xmlTextReaderPtr d) {
        if (d) {
            xmlFreeTextReader(d);
        }
    };
};

typedef xmlPtr<xmlTextReaderPtr> TextReaderPtr;

typedef xmlPtr<xmlChar*> CharPtr;
}


namespace mulca_mime {

using std::cerr;
using std::endl;
using std::runtime_error;

extern "C"  {
    void
    errorHandler(void * arg, const char* msg, xmlParserSeverities, xmlTextReaderLocatorPtr)
    {
        const char* fln = reinterpret_cast<const char*>(arg);
        cerr << "Got error: " <<fln<<" : "<<msg<< endl;
    }

};

static void
createFromNode(part* p, xmlNodePtr node, size_t xmlEnd)
{
    if (node==0) {
        return;
    }
    xmlAttrPtr attr = node->properties;
    while (attr) {
        const char* name = reinterpret_cast<const char*>(attr->name);
        switch (name[0]) {
            case 'i':
                if (0==strncmp("id", name, 2)) {
                    libxml::CharPtr v(xmlNodeGetContent(attr->children));
                    p->id = reinterpret_cast<const char*>(v.data_);
                }
                break;
            case 'l':
                if (0==strncmp("length", name, 6)) {
                    libxml::CharPtr v(xmlNodeGetContent(attr->children));
                    p->length() = boost::lexical_cast<size_t>(v.data_);
                }
                break;
            case 'o':
                if (0==strncmp("offset", name, 6)) {
                    libxml::CharPtr v(xmlNodeGetContent(attr->children));
                    p->offset() = boost::lexical_cast<size_t>(v.data_) + xmlEnd;
                }
                break;
            case 'c':
                if (0 == strncmp("content_type.", name, 13)) {
                    const char* f = name + 13;
                    switch (f[0]) {
                        case 'c':
                            if (0==strncmp("charset", f, 7)) {
                                libxml::CharPtr v(xmlNodeGetContent(attr->children));
                                p->header.content_type.charset = reinterpret_cast<const char*>(v.data_);
                            }
                            break;
                        case 'n':
                            if (0==strncmp("name", f, 4)) {
                                libxml::CharPtr v(xmlNodeGetContent(attr->children));
                                p->header.content_type.name = reinterpret_cast<const char*>(v.data_);
                            }
                            break;
                            break;
                        case 't':
                            if (0==strncmp("type", f, 4)) {
                                libxml::CharPtr v(xmlNodeGetContent(attr->children));
                                p->header.content_type.type = reinterpret_cast<const char*>(v.data_);
                            }
                            break;
                        case 's':
                            if (0==strncmp("subtype", f, 7)) {
                                libxml::CharPtr v(xmlNodeGetContent(attr->children));
                                p->header.content_type.subtype = reinterpret_cast<const char*>(v.data_);
                            }
                            break;
                    }
                } else if (0 == strncmp("content_transfer_encoding", name, sizeof("content_transfer_encoding")-1)) {
                    libxml::CharPtr v(xmlNodeGetContent(attr->children));
                    p->header.content_transfer_encoding = reinterpret_cast<const char*>(v.data_);
                } else if (0 == strncmp("content_id", name, sizeof("content_id")-1)) {
                    libxml::CharPtr v(xmlNodeGetContent(attr->children));
                    p->header.content_id= reinterpret_cast<const char*>(v.data_);
                } else if (0 == strncmp("content_disposition.", name, sizeof("content_disposition.")-1)) {
                    const char* f = name + sizeof("content_disposition");
                    switch (f[0]) {
                        case 'f':
                            if (0==strncmp("filename", f, 8)) {
                                libxml::CharPtr v(xmlNodeGetContent(attr->children));
                                p->header.content_disposition.filename = reinterpret_cast<const char*>(v.data_);
                            }
                            break;
                        case 'v':
                            if (0==strncmp("value", f, 5)) {
                                libxml::CharPtr v(xmlNodeGetContent(attr->children));
                                p->header.content_disposition.value = reinterpret_cast<const char*>(v.data_);
                            }
                            break;
                    }
                }
                break;
        }
        attr = attr->next;
    }
    return;
}

part_list_t
create_from_xml(const std::string& buffer, std::string::size_type& xmlEnd,const std::string& filename)
{
    part p(buffer, 0);
    part_list_t p_list;
    p_list.push_back(p);
    // FIXME
    xmlEnd = buffer.find("\n</message>\n");
    if (xmlEnd==std::string::npos) {
        throw(runtime_error("Can't find end of xml"));
    }
    xmlEnd += sizeof("\n</message>");
    libxml::TextReaderPtr reader(xmlReaderForMemory(buffer.c_str(), static_cast<int>(xmlEnd), 0, 0, XML_PARSE_RECOVER));
    xmlTextReaderSetErrorHandler(reader, &errorHandler, const_cast<char*>(filename.c_str()));
    int ret;
    if (reader != NULL) {
        ret = xmlTextReaderRead(reader);
        while (ret == 1) {
            const char * name = reinterpret_cast<const char*>(xmlTextReaderConstName(reader));
            if (xmlTextReaderNodeType(reader) == XML_READER_TYPE_ELEMENT
                    &&
                    (0 == strncmp("part", name, 4))) {
                part newPart(buffer, 0);
                createFromNode(&newPart, xmlTextReaderCurrentNode(reader), xmlEnd);
                p_list.push_back(newPart);
            }
            ret = xmlTextReaderRead(reader);
        }
        if (ret != 0) {
            throw("Failed to parse xml");
        }
    } else {
        throw("Can't create reader");
    }
    return p_list;
}

part_list_t get_parts(const char* xml, const size_t sz)
{
    std::string xml_string(xml, sz);
    /// @todo FIXME this usage is irrelevant: reference to xml_string
    /// will be stored in component class. I think, we need here some stub
    /// string, need to investigate it.
    part p(xml_string, NULL);
    part_list_t p_list;
    p_list.push_back(p);
    libxml::TextReaderPtr reader(xmlReaderForMemory(xml, static_cast<int>(sz), 0, 0, XML_PARSE_RECOVER));
    int ret;
    if (reader != NULL) {
        ret = xmlTextReaderRead(reader);
        while (ret == 1) {
            const char * name = reinterpret_cast<const char*>(xmlTextReaderConstName(reader));
            if (xmlTextReaderNodeType(reader) == XML_READER_TYPE_ELEMENT
                    && (0 == strncmp("part", name, 4))) {
                part newPart(xml_string, 0);
                createFromNode(&newPart, xmlTextReaderCurrentNode(reader), sz);
                p_list.push_back(newPart);
            }
            ret = xmlTextReaderRead(reader);
        }
        if (ret != 0) {
            throw parse_error("Can't parse xml");
        }
    } else {
        throw parse_error("Can't create xml reader");
    }
    return p_list;
}

}
