# Приоритизация
Скрипты для создания формулы приоритизации и расставления весов багам и таскам, высчитанных по формуле приоритизации.

[Описание на вики](https://wiki.yandex-team.ru/users/olyd/Prioritizacija-mobilnaja-pochta/) про приоритизацю в мобильной почте

### Подготовка к использанию скриптов

Для использования скриптов необходимо через пип установить следующие зависимости:
* Питоновский клиент для ST `pip3 install -i https://pypi.yandex-team.ru/simple/ startrek_client`
* Библиотеку yandex-yt  `pip3 install -i https://pypi.yandex-team.ru/simple/ yandex-yt`
* Библиотки для работы со статистикой `pip3 install -i https://pypi.yandex-team.ru/simple/ python-statface-client`

Для работы скриптов необходимы следующие токены:
* токен для ST - можно получить по [этой ссылке](https://oauth.yandex-team.ru/authorize?response_type=token&client_id=5f671d781aca402ab7460fde4050267b)
* токен для работы со Stat-ой  - можно получить по [этой ссылке](https://oauth.yandex-team.ru/authorize?response_type=token&client_id=801af94c94e040848ebe206086a7a4e2)

### Скрипт для нахождения формулы Приоритизации

`form.py` - Скрипт для нахождения формулы посчета весов, при помощи машинного обучения. Для создания формулы нелобходима
 выборка порядка 100 тикетов различного приоритета, желательно в равных пропорциях. Вес для тикетов изначально проставялется 
 рандомно исходя из его Priority (Severity). Для составления формулы используются следующие параметры:
 * Weight - вес, на котром формула обучается
 * Audience - аудитория, которую затрагивает данный баг
 * Dublicate Count - количество жалоб от пользователей
 * Text  - В данном поле через пробео вводится: Crash - Наличие или отсутствие крэша (-1/1 cоответственно), type - тип бага, 
 повышающий/понижающий коэффициент.
 
 Для работы формулы необходимо в скрипте задать:
 * `oauth_token_startrek`  - токен для ST
 * `user` = пользователь (ваш ник на стафе)
 * `issues = ['MOBILEMAIL-8207', 'MOBILEMAIL-11727', 'MOBILEMAIL-11452']` - массив тикетов на основании которых, будет
  обучаться формула. Все тикеты в массиве должны содержать все указанные выше поля.
  
На выходе работы скрипта следующие файлы:
 * data - файл с данными, на которых обучается формула
 * summary - общая статистика по работе каждой из формул 
 * файлы с формулами, в имении которых указана степень польному и коэффициент альфа (занулить не значимые слагаемые)
 
в файле `summary`:
 * degree - Степень полинома
 * alpha - Коэффициент для зануления незначимых слагаемых		
 * score - корреляция
 * len  - количество не нулевых слагаемых в полиноме
 * my_score - общий процент "угаданных" приоритетов
 * minor - процент "угаданных" приоритетов	среди миноров
 * normal - процент "угаданных" приоритетов	среди нормалов
 * crit - процент "угаданных" приоритетов среди критов

в файлах с функциями - наиболее важным выводом является самы полином который представлен в таком виде:
```
F U N C T I O N: 
	17.20762 * audience,
	250.9653 * duplicatesCount,
	48.10954 * crash * audience,
	155.4487 * crash * type,
	0.28604 * audience**2,
	2.15705 * audience * duplicatesCount,
	-5.51209 * audience * type,
	-5.54095 * duplicatesCount**2,
	39.04543 * type**2
``` 
где самой функцией является сумма всех строк (вывод оптимизирован для питона)

### Скрипт проставления аудитории и весов

`pony.py` - скрипт для проставления аудитории по событию, которое было заранее занесено в поле Tag тикета.
Этот же скрипт проставляет новый вес для тикета в поле `Weight 1`, которые был высчитан по формуле приоритизации и меняет 
`Priority` если это необходимо.

Для работы скрипта необходимо:

 * oauth_token_stat -токен для ST
 * oauth_token_startrek - токен для работы со Stat-ой
 * user - пользователь
 * filter - фильтр багов для которых необхоимо проставить аудиторию и вес
 * stop_word - стоп слово в тэгах тикета, что бы скрипт для него не считал аудиторию
 * ticket = ['MOBILEMAIL-8207', 'MOBILEMAIL-11727', 'MOBILEMAIL-11452'] - массив тикетов, если скрипт запускается с ключом -t
 для изменения отдельных тикетов без фильтра.
 
В формула приоритизации вставляется в массив function, пример:
```
function = [
        17.20762 * audience,
        250.9653 * duplicatesCount,
        48.10954 * crash * audience,
        155.4487 * crash * type,
        0.28604 * audience ** 2,
        2.15705 * audience * duplicatesCount,
        -5.51209 * audience * type,
        -5.54095 * duplicatesCount ** 2,
        39.04543 * type ** 2
    ]
```
    
Скрипт поддерживает работу с ключами:

    * -np - не менять приоритет для обработанных тикетов (для всех тикетов в фильтре)
    * -na - не менять аудиторию для обработанных тикетов (для всех тикетов в фильтре)
    * -nw - не менять вес для обработанных тикетов (для всех тикетов в фильтре)
    * -t - запустить скрипт на отедльном массиве тикетов. Массив тикетов указывается в переменной `ticket` в начале скрипта.
    
Пример:
    Во всех тикетах будет меняться только аудитория - `python3 pony.py -np -nw`
    Во всех тикетах будет меняться вес и приоритет, аудитория будет оставаться прежней `python3 pony.py -na`








