# Example run : python3 pony_2.py

# https://api.stat.yandex-team.ru/_api/statreport/json/Mail/Totals/Mail_Mobile/EventAudience2?_format=json&_period_distance=30&device_type=_total_&event_name=_total_&os_major_version=_total_&platform=android&scale=d&session_type=_total_&type=json
# https://github.yandex-team.ru/statbox/python-statinfra/blob/master/docs/statface_client.md

import argparse
import datetime
import smtplib
import time
import urllib3

import statface_client
from startrek_client import Startrek

from email.mime.multipart import MIMEMultipart
from email.mime.text import MIMEText

oauth_token_startrek = 'AQAD-***'
oauth_token_stat = 'AQAD-****'
user = 'arovkova'
application = 'disk'



ticket = ['MOBDISK-17149']

filters = dict(
    filter_all='Queue: "MOBDISK" AND Tags: special_tag',
    filter_support='',
    filter_only_new='')


def output(string):
    print("{date}   {string}".format(date=datetime.datetime.now(), string=string))


class Prioritization:
    def __init__(self, flags):
        self.all_priority = {'minor': 100, 'normal': 1000, 'critical': 10000, 'blocker': 100000}
        self.accuracy = {'Precisely': 1, 'Middle': 0.75, 'Rough': 0.5}

        self.audience_android = {'150': 1, '500': 2, '1500': 3,
                                 '2600': 5, '6000': 7, '13000': 9,
                                 '26000': 11, '300000': 13}

        self.audience_ios = {'150': 1, '500': 2, '1500': 3,
                             '2600': 5, '6000': 7, '13000': 9,
                             '26000': 11, '300000': 13}

        self.weight_complaints = {'few': 1, 'moderately': 1.2, 'much': 1.5}
        self.count_complaints = {'few': 1, 'moderately': 5, 'much': 1000}

        self.bug_type = { "Приложение_не_запускается": 10,
                          "Креш_в_foreground": 8,
                          "Креш_в_background": 2,
                          "Креш_в_unknown": 5,
                          "Проблему_обойти_никак_невозможно": 10,
                          "Проблему_можно_обойти_только_очистив_данные": 7,
                          "Проблема_создает_неудобства": 2,
                          "Проблему_можно_обойти_не_закрывая_приложение": 2,
                          "Потеря_данных": 10,
                          "Перфоманс": 3,
                          "UI_проблема_распердыр": 9,
                          "UI_проблема_средняя": 3,
                          "UI_проблема_мелкая": 1,
                          "Безопасность": 8,
                          "Проблема_не_видна_пользователю": 1,
                          "Жор": 7,
                          '-': None}

        self.feature = {  "Authorization": 100,
                          "Auto-upload": 100,
                          "Unlim": 100,
                          "Feed": 90,
                          "Files": 90,
                          "Notes": 90,
                          "All_photos": 100,
                          "Offline": 50,
                          "Navigation_tabs": 50,
                          "Thumbs": 55,
                          "Group_mode": 50,
                          "Upload_to_from_third_party_apps": 50,
                          "Upload_by_FAB": 50,
                          "Create_folders": 50,
                          "Rename_files_and_folders": 50,
                          "Move_files_and_folders": 50,
                          "Copy_files_and_folders": 50,
                          "Download_files_and_folders": 50,
                          "Save_On_Device": 50,
                          "Delete_files_and_folders": 50,
                          "Open_in": 50,
                          "Share_original_file": 50,
                          "Copy_link": 50,
                          "Delete_link": 50,
                          "Search": 50,
                          "Photo_viewer": 90,
                          "Video_player": 90,
                          "Audio_player": 10,
                          "Feedback": 90,
                          "Systems_folders": 40,
                          "Camera_Roll": 60,
                          "Albums": 60,
                          "Settings": 10,
                          "Cache": 10,
                          "Trash": 10,
                          "Notifications": 60,
                          "Shared_folders": 10,
                          "PIN_code": 50,
                          "Delete_Local_Photos": 50,
                          "Promo": 90,
                          "Aviary": 10,
                          "Vista": 40,
                          "Public_in_app": 50,
                          "Touch_redirect": 50,
                          "Splash_Screen": 10,
                          "ПП": 80,
                          "Icon": 80,
                          "Badge": 60,
                          "Unknown": 50}

        self.stop_word = 'stop_word'
        self.tag_pony_done = 'pony_done'

        self.is_update_priotity = not flags.not_priority
        self.is_update_weight = not flags.not_weight
        self.is_update_audience = not flags.not_audience
        self.list_ticket = flags.ticket

        self.filter = filters['filter_support'] if flags.filter_support else filters['filter_all']
        self.filter = filters['filter_only_new'] if flags.filter_only_new else self.filter

        self.all_event = []

        self.ticket_change_priority = 'List of tickets with CHANGE priority: \n'
        self.ticket_will_crit_or_blocker = 'I think, This is Critical OR Blocker : \n'
        self.comment = []

    def add_ticket_in_list_change_priority(self, ticket, old_priority, new_priority):
        self.ticket_change_priority = '{}https://st.yandex-team.ru/{}:   {} -> {}\n' \
            .format(self.ticket_change_priority, ticket, old_priority.capitalize(), new_priority.capitalize())

    def add_ticket_in_list_crit_or_blocker(self, ticket, old_priority, new_priority):
        self.ticket_will_crit_or_blocker = '{}https://st.yandex-team.ru/{}:   {} -> {}\n' \
            .format(self.ticket_will_crit_or_blocker, ticket, old_priority.capitalize(), new_priority.capitalize())

    def create_comments(self):
        client = Startrek(base_url='https://st-api.yandex-team.ru',
                          useragent=user,
                          token=oauth_token_startrek)
        for item in self.comment:
            ticket = client.issues[item['key']]
            ticket.comments.create(text=item['text'], summonees=['anovarov'])
            output("Comment was created in Startrek for {}".format(['item.key']))


class Audience:
    def __init__(self):
        self.client = statface_client.StatfaceClient(oauth_token=oauth_token_stat,
                                                     host=statface_client.STATFACE_PRODUCTION)
        output("Client StatFace was created.")
        self.report = self.client.get_report('Mail/Totals/Mail_Mobile/EventAudience3')

    def get_all_event(self, platform):
        data = self.report.download_data(scale='daily',
                                         application=application,
                                         _period_distance=30,
                                         device_type='_total_',
                                         os_major_version='_total_',
                                         platform=platform,
                                         session_type='_total_',
                                         type='json')

        output("Data from report was gotten.")

        if not len(data):
            output(
                "Data from report ia empty. All event for '{platform}' wasn't gotten.".format(platform=platform))
            return 0

        event = []
        for item in data:
            event.append(item['event_name'])

        output("Count of different event for '{platform}' is {len}".format(platform=platform, len=len(event)))
        return event

    def get_audience_by_event(self, event, platform):
        data = self.report.download_data(scale='daily',
                                         application=application,
                                         _period_distance=6,
                                         device_type='_total_',
                                         event_name=event,
                                         os_major_version='_total_',
                                         platform=platform,
                                         session_type='_total_',
                                         type='json')

        output("Data from report was gotten.")

        if not len(data):
            output("Data from report ia empty. "
                   "There isn't action '{event_name}' for '{platform}' during 7 days."
                   "Audience is 0%.".format(event_name=event, platform=platform))
            return 0

        average = 0
        for item in data:
            average += item['uuids_count']

        average = float(average / len(data))
        output("Average count of '{event_name}' for '{platform}' == {average}."
               .format(event_name=event, platform=platform, average=average))
        return average

    def get_audience(self, event_name, platform):
        total = self.get_audience_by_event('_total_', platform)
        event = self.get_audience_by_event(event_name, platform)
        event_audience = float(event / 7)

        output("Daily audience of '{}' == {}.".format(event, event_audience))
        return event_audience


class Ticket:
    def __init__(self, item, prioritization):
        self.is_update_audience = True
        self.key = item.key

        self.platform = self.get_platform_in_ticket(item.components)
        # self.event_name = item.eventFromMetrica if item.eventFromMetrica else self.get_event_in_ticket(item.tags,
        #                                                                                                prioritization.all_event,
        #                                                                                                prioritization.stop_word)

        self.priority = item.priority
        self.audience = item.audience
        self.weight = item.weightOne
        self.type = prioritization.bug_type[item.bugType] if item.bugType else None

        self.feature = self.get_information_from_tags(item.tags, prioritization.feature)
        self.accuracy = self.get_information_from_tags(item.tags, prioritization.accuracy)

        self.numberOfComplaints = self.get_complaints(item.numberOfComplaints if item.numberOfComplaints else 0,
                                                      prioritization.count_complaints,
                                                      prioritization.weight_complaints)

    def get_complaints(self, numberOfComplaints, count_complaints, weight_complaints):
        for key, value in count_complaints.items():
            if int(numberOfComplaints) <= int(value):
                return weight_complaints[key]

        return None

    def get_type(self, all_priority):
        if self.weight < all_priority['minor']:
            return 'minor'
        if self.weight < all_priority['normal']:
            return 'normal'
        if self.weight < all_priority['critical']:
            return 'critical'

        return 'blocker'

    @staticmethod
    def get_audience(audience, priority_audience):
        for key in priority_audience.keys():
            if int(audience) <= int(key):
                return priority_audience[key]

        output("Audience wasn't found. Audience = {}".format(audience))
        return None

    def get_platform_in_ticket(self, arr_components):
        android = 'YD Android'
        ios = 'YD iOS'

        for component in arr_components:
            if component.name.lower() == android.lower():
                return android
            elif component.name.lower() == ios.lower():
                return ios

        output("Platform wasn't found. Components = [{}]".format(i.name for i in arr_components))
        self.is_update_audience = False
        return None

    def get_event_in_ticket(self, arr_tags, all_event, stop_word):
        if arr_tags.count(stop_word):
            output("Stop word was found in ticket.")
            self.is_update_audience = False
            return None

        for tag in arr_tags:
            if all_event.count(tag):
                return tag

        output("Event wasn't found. Tags = {}".format(arr_tags))
        self.is_update_audience = False
        return None

    def get_information_from_tags(self, arr_tags, dict):
        for tag in arr_tags:
            if tag in dict.keys():
                return dict[tag]

        output("Feature wasn't found. Tags = {}".format(arr_tags))
        self.is_update_audience = False
        return None

    def get_weight_for_ticket(self, proiritization_audience):
        audience = self.get_audience(self.audience, proiritization_audience)

        if (self.feature is None) or (self.type is None) or (audience is None) or (self.accuracy is None):
            output(
                "There isn't any field for ticket {}. Feature = {}, Audience = {}, Bug Type = {}, Accuracy = {}."
                    .format(self.key,
                            self.feature,
                            audience,
                            self.type,
                            self.accuracy))
            self.weight = -1
            return

        function = [self.feature,
                    self.type,
                    audience,
                    self.accuracy,
                    self.numberOfComplaints]

        self.weight = 1
        for item in function:
            self.weight *= float(item)

        self.weight = 0 if self.weight < 0 else int(self.weight)
        return self.weight

    def update_priority(self, prioritization):
        priority_by_weight = self.get_type(prioritization.all_priority).lower()

        if self.priority.key != priority_by_weight:
            if ['critical', 'blocker'].count(priority_by_weight):
                prioritization.add_ticket_in_list_crit_or_blocker(self.key, self.priority.key, priority_by_weight)
                text = 'I think this is **{}**. Weight = {}'.format(priority_by_weight.capitalize(), self.weight)
            else:
                prioritization.add_ticket_in_list_change_priority(self.key, self.priority.key, priority_by_weight)
                text = 'Change priority by pony_prioritization **{} -> {}**. Weight = {}'. \
                    format(self.priority.key.capitalize(), priority_by_weight.capitalize(), self.weight)

            prioritization.comment.append(dict(key=self.key, text=text))
            self.priority.key = priority_by_weight

        return prioritization


def processed_tickets(prioritization):
    urllib3.disable_warnings()
    client = Startrek(base_url='https://st-api.yandex-team.ru',
                      useragent=user,
                      token=oauth_token_startrek)

    issues = []
    if prioritization.list_ticket:
        for item in ticket:
            issues.append(client.issues[item])
            prioritization = update_tickets(prioritization, issues)
    else:
        output('Filter: {}'.format(prioritization.filter))
        issues = client.issues.find('{} AND Tags: !{}'.format(prioritization.filter,
                                                              prioritization.tag_pony_done))
        if not len(issues):
            output("There aren't tickets.")
        while len(issues):
            prioritization = update_tickets(prioritization, issues)
            time.sleep(7)
            issues = client.issues.find('{} AND Tags: !{}'.format(prioritization.filter,
                                                                  prioritization.tag_pony_done))
        delete_tag_pony(prioritization)

    output(prioritization.ticket_change_priority)
    output(prioritization.ticket_will_crit_or_blocker)
    prioritization.create_comments()


def update_tickets(prioritization, issues):
    for item in issues:
        output("Start processing for ticket {}".format(item.key))
        data_item = Ticket(item, prioritization)

        if prioritization.is_update_audience and data_item.is_update_audience:
            audience = Audience()
            data_item.audience = audience.get_audience(data_item.event_name, data_item.platform)

        if prioritization.is_update_weight:
            if data_item.platform.count("iOS"):
                data_item.get_weight_for_ticket(prioritization.audience_ios)
            else:
                data_item.get_weight_for_ticket(prioritization.audience_android)

        if prioritization.is_update_priotity:
            prioritization = data_item.update_priority(prioritization)

        output("For ticket: Weight = {}, Priority = {}".format(data_item.weight, data_item.priority.key.capitalize()))

        if prioritization.list_ticket:
            item.update(weightOne=data_item.weight, audience=data_item.audience, priority=data_item.priority)
        else:
            item.update(tags={'add': [prioritization.tag_pony_done]}, weightOne=data_item.weight,
                        audience=data_item.audience, priority=data_item.priority)
        output("The ticket {} was processed.\n\n".format(item.key))

    return prioritization


def delete_tag_pony(prioritization):
    urllib3.disable_warnings()
    client = Startrek(base_url='https://st-api.yandex-team.ru',
                      useragent=user,
                      token=oauth_token_startrek)

    issues = client.issues.find('{} AND Tags: {}'.format(prioritization.filter, prioritization.tag_pony_done))
    while len(issues):
        for item in issues:
            item.update(tags={'remove': [prioritization.tag_pony_done]})
            output("Tag {} delete for ticket {}".format(prioritization.tag_pony_done, item.key))
        time.sleep(7)
        issues = client.issues.find(
            '{} AND Tags: {}'.format(prioritization.filter, prioritization.tag_pony_done))


def main():
    parser = argparse.ArgumentParser(add_help=False)

    argument = parser.add_argument_group(title='Parametrs')

    argument.add_argument('--help', '-h', action='help', help='Helper')
    argument.add_argument('--not_priority', '-np', action='store_const', const=True, default=False,
                          help="Don't change priority")
    argument.add_argument('--not_weight', '-nw', action='store_const', const=True, default=False,
                          help="Don't change weight")
    argument.add_argument('--not_audience', '-na', action='store_const', const=False, default=True,
                          help="Don't change audience")
    argument.add_argument('--ticket', '-t', action='store_const', const=True, default=False,
                          help="Use massive of ticket")
    argument.add_argument('--filter_support', '-f', action='store_const', const=True, default=False,
                          help="Filter for change field 'Number Of Complaints'")
    argument.add_argument('--filter_only_new', '-fn', action='store_const', const=True, default=False,
                          help="Filter for change only new tickets")

    flags = parser.parse_args()
    prioritization = Prioritization(flags)

    output("The script was run with argument:\n"
           "\t Update audience = {}\n"
           "\t Update weight = {}\n"
           "\t Update priority = {}\n"
           "\t Massive of tickets = {}\n"
           "\t Filter 'Change field Number Of Complaints' = {}\n"
           "\t Filter for only new tickets = {}\n".format(prioritization.is_update_audience,
                                                          prioritization.is_update_weight,
                                                          prioritization.is_update_priotity,
                                                          prioritization.list_ticket,
                                                          flags.filter_support, flags.filter_only_new))

    if flags.filter_support and flags.filter_only_new:
        output("The script was run with key '-f' and '-fn'. This is error. Restart the script with one of the keys")
        exit(0)

    audience = Audience()
    output("Get all event from metrica....")
    prioritization.all_event = audience.get_all_event(platform='android')
    prioritization.all_event.extend(audience.get_all_event(platform='iOS'))
    prioritization.all_event = list(set(prioritization.all_event))
    prioritization.all_event.sort()
    output("All event from metrica was gotten")

    processed_tickets(prioritization)


if __name__ == '__main__':
    main()
