# Общее
Нужно установить клиент testpalm api

`pip3 --no-cache-dir install -i https://pypi.yandex-team.ru/simple yandex_tp_api_client`

Скрипт для расскатки заданий для асессоров. Для работы скрипта необходимы два json файла:

`testing_data.json` - файл с тестовыми данными
`suites.json` - файл с ранами

### Запуск скрипта
У запуска есть четыре параметра:
1. `-p` или `--project` - ОС (iOS или Android)
2. `-r` или `--run_process` - флаг, который создает бронь и запускает процесс в хитмане (версия в пальме и тикет в стартреке уже созданы)
3. `-b` или `--booking` - флаг, в который можно передать id регулярной брони (новая бронь создана не будет)
4. `-s` илл `--split` - флаг, который разбивает один большой сьют на раны фиксированного размера (количество кейсов в ране `run_size`, цветовая тема приложения `themes` и окружения `environments` задаются в файле `testing_data`)

Примеры:

`python3 Run_assessors.py -p Android -r` - создает бронь и запускает процесс в Hitman для Android проекта

`python3 Run_assessors.py -p iOS` - создает версию и раны в TP, тикет в стартреке, создает бронь и запускает процесс в Hitman для iOS проекта 

`python3 Run_assessors.py -p iOS -b 29733` - создает версию и раны в TP, тикет в стартреке, запускает процесс в Hitman для iOS проекта с указанной бронью


### Входные данные

Перед каждым запуском скрипта проверьте корректность следующих данных в файле testing_data.json:
* версия приложений для тестирования `version_app`
* счетчик запуска ассесоров в версии `part`
* корректность ссылок на билд `build` и дебажный билд `build_debug`
* тикет на тестирование версии `testing_ticket`
* проект в тестпалм `testpalm_project` и `testpalm`
* спецусловия прохождения запуска для асессоров `special_conditions`

Для работы скрипта необходимо заполнить следующие поля:

####  Поля, которые нужно заполнить один раз перед первым использованием скрипта

* `AUTH_ST` - токен для авторизации в StarTrack (для его получения пройдите по ссылке https://oauth.yandex-team.ru/authorize?response_type=token&client_id=5f671d781aca402ab7460fde4050267b)

* `AUTH_TP` - токен для авторизации в TestPalm (для его получения пройдите по ссылке https://oauth.yandex-team.ru/authorize?response_type=token&client_id=6d967b191847496a8a7077e2e636142f)

* `AUTH_HITMAN` - токен для авторизации в Hitman (для его получения пройдите по ссылке https://oauth.yandex-team.ru/authorize?response_type=token&client_id=a3891d91bf9a4afeb1b7fba8e0735d49 )

* `requester` - ваш логин в Yandex

####  Поля, которые нужно заполнять каждый раз перед  использованием скрипта

* `version_app` - версия тестируемого релиза

* `part` - какой запуск ассесоров в рамках данного релиза 

* `build` - ссылка на Я.Диск на релизную сбоку билда

* `build_debug` - ссылка на Я.Диск на дебажную сбоку билда (Для `Android` платформы - вставить ссылку, для `iOS` - оставить его пустым)

* `testing_ticket` - тикет на тестирование версии

* `scenario` - выбор сценария, по-которому работает скрипт. Возможные значение:
``` Android: "bl1", "bl2", "custom", "regress"
    iOS: "custom", "regress", "blSmall", "blBig1", "blBig2"

```

###  Заполняем файл suites.json

Для выбора, какие раны будут отдаваться ассессорам используются ключи:

* `bl1` \ `bl2` - запуск первой\второй версии БЛ 

* `bl2` - запуск второй версии БЛ 

* `regress` - Запуск full Regress

* `custom` - Запуск определенных ранов

Каждый ран состоит из следующих частей:

* `run` - имя рана 

* `tags` - теги (например, тег `notSuitableForFarm` запрещает прохождение ранов на ферме)

* `enviroment` - окружение, в котором его необходимо выполнить

* `key` - id-шник рана (берется из URL)