import datetime
import json
import os
import random
import sys
import yt.wrapper as yt


def output_in_console(string):
    print("{date}   {string}".format(date=datetime.datetime.now(), string=string))


def input_from_console(string):
    data = input("{date}   {string}".format(date=datetime.datetime.now(), string=string))
    return data


def stop_script(string):
    output_in_console('\x1b{}\x1b[0m'.format(string))
    sys.exit(0)


def special_condition(data):
    text = '{text}\n' \
           'Обязательно в заведенных тикетах проставлять Найдено в версиях/Affected Version: ' \
           '{platform} {version} part {part} testing'.format(text='\n'.join(data['special_conditions']),
                                                             platform=data['platform'],
                                                             version=data['version_app'],
                                                             part=data['part'])

    if data['build_debug']:
        text = '{text}\n' \
               'Ссылка на дебаг версию приложения - {debug}'.format(text=text,
                                                                    debug=data['build_debug'])

    output_in_console('\x1b[1mInformation for assessors: \n\n {}\x1b[0m '.format(text))

    incorrect_data = input_from_console('\x1b[1m\n'
                                        'Is data correct? (tap \'Enter\' for continue; \'No\' for break) \x1b[0m ')

    if incorrect_data:
        stop_script('Running of script was stopped by user')

    return text


def hitman_start(data, special_condition):
    output_in_console('Create task for assessors in Hitman....')

    import time
    time = int(time.time() * 1000.0)
    recTime = int(75)

    testpalm_project = str(data['testpalm_project'])
    version_app = '{}part{}'.format(str(data['version_app']).replace('.', ''),
                                    str(data['part']))
    version_testpalm = 'Assessors{}{}'.format(str(data['platform']), version_app)
    requester = str(data['requester'])
    build = data['build']
    telegram = data['telegram']
    testing_ticket = data['testing_ticket']
    rand_string = ''.join([random.choice(list('123456789qwertyuiopasdfghjklzxcvbnm')) for x in range(6)])


    yt.config["proxy"]["url"] = "hahn"
    yt.config["token"] = data['AUTH_YT']
    yt.write_table('//home/assessor-research/qa/testing_start/{}/{}{}'.format(testpalm_project,
                                                                              version_app,
                                                                              rand_string),
                   [{"current_ts": time,
                     "requester": requester,
                     "instruction": "https://wiki.eva.yandex-team.ru/search/assessors-testing/mobmail/",
                     "namespace": testpalm_project,
                     "only_exp_assessors": json.loads("false"),
                     "special_condition": special_condition,
                     "test_stend": build,
                     "parent_ticket": testing_ticket,
                     "is_report_write_to_ticket_required": 'true',
                     "version": version_testpalm,
                     "recommendation_time": recTime,
                     "telegram": telegram}],
                   format=yt.JsonFormat(attributes={"encode_utf8": False}))

    output_in_console('The task for assessors was created!')


def main():
    testing_data = json.load(open(os.path.join(os.path.dirname(__file__), 'testing_data.json')))
    text_for_assessors = special_condition(testing_data)
    hitman_start(testing_data, text_for_assessors)


if __name__ == "__main__":
    main()
