import json
import requests

# status should be one of "OPEN", "CLOSED", "SEALED"
def change_crashgroup_status(app_id, crash_group_id, token, status):
    url = 'https://api.appmetrica.yandex.ru/management/v1/application/{app_id}/crashes/{crash_group_id}/status'.format(
        app_id=app_id,
        crash_group_id=crash_group_id
    )
    resp = requests.post(url, headers={
        'Authorization': 'OAuth {}'.format(token)
    }, data=json.dumps({
        'value': status
    })
                         )
    if resp.status_code == 200:
        print("status for crashgroup {} changed to {}".format(crash_group_id, status))
    else:
        print("Failed to add comment: status {}, msg:".format(resp.status_code, resp.content))


def add_comment(app_id, crash_group_id, token, comment):
    url = 'https://api.appmetrica.yandex.ru/management/v1/application/{app_id}/crashes/{crash_group_id}/comment'.format(
        app_id=app_id,
        crash_group_id=crash_group_id
    )
    resp = requests.post(url, headers={
                             'Authorization': 'OAuth {}'.format(token)
                         }, data=json.dumps({
                             'value': comment
                         })
    )
    if resp.status_code == 200:
        print("Comment added for crashgroup {}".format(crash_group_id))
    else:
        print("Failed to add comment for crashgroup: status {}, msg:".format(crash_group_id, resp.status_code, resp.content))


def delete_comment(app_id, crash_group_id, token):
    url = 'https://api.appmetrica.yandex.ru/management/v1/application/{app_id}/crashes/{crash_group_id}/comment'.format(
        app_id=app_id,
        crash_group_id=crash_group_id
    )
    resp = requests.delete(url, headers={
        'Authorization': 'OAuth {}'.format(token)
    })
    if resp.status_code == 200:
        print("Comment deleted")
    else:
        print("Failed to delete comment: status {}, msg:".format(resp.status_code, resp.content))

