import argparse
import json
import urllib3
from testpalm_client import TestPalmApi, Auth
urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)

ROBOT_NOT_COVERED_ATTRIB = u'pr_robot_not_covered'
TAGS_ATTRIBUTE_ID = u'54b51715e4b083fc72fbb4e1'
CASE_PRIORITY_ATTRIBUTE_ID = u'54292800e4b0b658a756b7ea'

testcases_to_mark = """mobmail_android-5676
mobmail_android-5677
mobmail_android-5673
mobmail_android-5679
mobmail_android-5680
mobmail_android-5768
mobmail_ansroid-5682
mobmail_android-5792
mobmail_android-5793
mobmail_android-5795
mobmail_android-5791
mobmail_android-5799
mobmail_android-5802
mobmail_android-5805
mobmail_android-5808
mobmail_android-5823
mobmail_android-5814
mobmail_android-5806
mobmail_android-5821
mobmail_android-5818
mobmail_android-5801
mobmail_android-5801
mobmail_android-5734
mobmail_android-5863
mobmail_android-5735
mobmail_android-5736
mobmail_android-5788
mobmail_android-5761
mobmail_android-5761
mobmail_android-5761
mobmail_android-5819
mobmail_android-5772
mobmail_android-5774
mobmail_android-5747
mobmail_android-5779
mobmail_android-5748
mobmail_android-5782
mobmail_android-5751
mobmail_android-5749
mobmail_android-5783
mobmail_android-5752
mobmail_android-5784
mobmail_android-5750
mobmail_android-5753
mobmail_android-5754
mobmail_android-5757
mobmail_android-5756
mobmail_android-5882
mobmail_android-5877
mobmail_android-5884
mobmail_android-5878
mobmail_android-2092
mobmail_android-5881
mobmail_android-5879
mobmail_android-3498
mobmail_android-4944
mobmail_android-4951
mobmail_android-5892
mobmail_android-2112
mobmail_android-5894
mobmail_android-5126
mobmail_android-5893
mobmail_android-5329
mobmail_android-5329
mobmail_android-2078
mobmail_android-5707
mobmail_android-2078
mobmail_android-5035
mobmail_android-5036
mobmail_android-2078
mobmail_android-3343
mobmail_android-5039
mobmail_android-5040
mobmail_android-1413
mobmail_android-5046
mobmail_android-2097
mobmail_android-5158
mobmail_android-2101
mobmail_android-2102
mobmail_android-3447
mobmail_android-3712
mobmail_android-3709
mobmail_android-5613 
mobmail_android-2067
mobmail_android-3406
mobmail_android-3916
mobmail_android-3413
mobmail_android-5732
mobmail_android-2288
mobmail_android-5415
mobmail_android-5414
mobmail_android-5789
mobmail_android-5482
mobmail_android-5508
mobmail_android-5640
mobmail_android-3444
mobmail_android-5639
mobmail_android-2066
mobmail_android-5788
mobmail_android-2105
mobmail_android-5158
mobmail_android-2009
mobmail_android-3409
mobmail_android-3538
mobmail_android-5404
mobmail_android-5407
mobmail_android-5405
mobmail_android-3684
mobmail_android-5409
mobmail_android-5418
mobmail_android-3383
mobmail_android-5419
mobmail_android-5343
mobmail_android-3382
mobmail_android-5735
mobmail_android-5736
mobmail_android-5734
mobmail_android-5339
mobmail_android-3384
mobmail_android-5788
mobmail_android-2284
mobmail_android-1572
mobmail_android-5340
mobmail_android-2048
mobmail_android-3384
mobmail_android-3387
mobmail_android-3388
mobmail_android-5350
mobmail_android-2315
mobmail_android-2426
mobmail_android-3386
mobmail_android-3392
mobmail_android-3415
mobmail_android-3389
mobmail_android-5351
mobmail_android-3393
mobmail_android-2091
mobmail_android-3418
mobmail_android-5395
mobmail_android-3523
mobmail_android-3492
mobmail_android-4346
mobmail_android-3528
mobmail_android-4358
mobmail_android-4445
mobmail_android-5422
mobmail_android-4628
mobmail_android-5400
mobmail_android-3408
mobmail_android-5354
mobmail_android-3491
mobmail_android-5344
mobmail_android-5421
mobmail_android-3566
mobmail_android-5393
mobmail_android-1788
mobmail_android-5044
mobmail_android-4366
mobmail_android-5348
mobmail_android-5423
mobmail_android-4367
mobmail_android-5790
mobmail_android-3495
mobmail_android-3307
mobmail_android-5428
mobmail_android-5435
mobmail_android-3543
mobmail_android-2332
mobmail_android-2080
mobmail_android-3542
mobmail_android-3829
mobmail_android-3829
mobmail_android-3544
mobmail_android-3546
mobmail_android-5462
mobmail_android-5436
mobmail_android-5437
mobmail_android-5439
mobmail_android-5438
mobmail_android-5440
mobmail_android-5434
mobmail_android-5441
mobmail_android-5453
mobmail_android-5459
mobmail_android-5460
mobmail_android-2079
mobmail_android-3504
mobmail_android-3505
mobmail_android-2009
mobmail_android-3549
mobmail_android-3511
mobmail_android-3548
mobmail_android-5369
mobmail_android-3328
mobmail_android-4921
mobmail_android-4920
mobmail_android-4928
mobmail_android-4922
mobmail_android-5371
mobmail_android-5372
mobmail_android-5373
mobmail_android-5034
mobmail_android-5374
mobmail_android-5043
mobmail_android-5033
mobmail_android-5032
mobmail_android-5059
mobmail_android-5060
mobmail_android-5375
mobmail_android-3474
mobmail_android-5618
mobmail_android-5633
mobmail_android-4441
mobmail_android-4766
mobmail_android-5633
mobmail_android-2115
mobmail_android-5619
mobmail_android-5621
mobmail_android-5624
mobmail_android-5609
mobmail_android-5610
mobmail_android-5626
mobmail_android-5611
mobmail_android-5631
mobmail_android-5627
mobmail_android-5369
mobmail_android-3510
mobmail_android-5370
mobmail_android-5536
mobmail_android-2118
mobmail_android-2282
mobmail_android-2120
mobmail_android-2308
mobmail_android-3714
mobmail_android-3913
mobmail_android-5761
mobmail_android-3525
mobmail_android-5538
mobmail_android-5772
mobmail_android-5774
mobmail_android-4068
mobmail_android-3522
mobmail_android-4075
mobmail_android-5747
mobmail_android-3524
mobmail_android-3707
mobmail_android-5779
mobmail_android-2433
mobmail_android-5749
mobmail_android-5748
mobmail_android-5045
mobmail_android-5750
mobmail_android-5217
mobmail_android-5782
mobmail_android-5783
mobmail_android-5751
mobmail_android-5752
mobmail_android-4303
mobmail_android-4304
mobmail_android-5784
mobmail_android-5097
mobmail_android-5754
mobmail_android-5753
mobmail_android-5756
mobmail_android-4303
mobmail_android-5757
mobmail_android-4894
mobmail_android-5786
mobmail_android-5515
mobmail_android-5853
mobmail_android-5858
mobmail_android-5848
mobmail_android-5509
mobmail_android-5506
mobmail_android-5900
mobmail_android-5870
mobmail_android-3383
mobmail_android-3383
mobmail_android-2112
mobmail_android-3382
mobmail_android-3384
mobmail_android-3385
mobmail_android-3508
mobmail_android-2048
mobmail_android-3387
mobmail_android-2112
mobmail_android-3388
mobmail_android-3386
mobmail_android-2315
mobmail_android-3389
mobmail_android-3392
mobmail_android-3393
mobmail_android-4346
mobmail_android-2290
mobmail_android-4628
mobmail_android-4358
mobmail_android-1788
mobmail_android-3491
mobmail_android-5051
mobmail_android-4366
mobmail_android-3517
mobmail_android-4367
mobmail_android-3311
mobmail_android-5348
mobmail_android-3566
mobmail_android-3307
mobmail_android-5042
mobmail_android-5874
mobmail_android-2332
mobmail_android-2080
mobmail_android-3543
mobmail_android-5875
mobmail_android-5126
mobmail_android-3544
mobmail_android-3829
mobmail_android-3542
mobmail_android-5042
mobmail_android-3546
mobmail_android-5428
mobmail_android-5849
mobmail_android-5870
mobmail_android-5129
mobmail_android-5131
mobmail_android-5853
mobmail_android-5127
mobmail_android-5854
mobmail_android-5858
mobmail_android-5866
mobmail_android-5761
mobmail_android-5774
mobmail_android-5771
mobmail_android-5900
mobmail_android-5770
mobmail_android-5747
mobmail_android-5779
mobmail_android-5748
mobmail_android-5779
mobmail_android-5779
mobmail_android-5748
mobmail_android-5780
mobmail_android-5749
mobmail_android-5772
mobmail_android-5905
mobmail_android-5781
mobmail_android-5902
mobmail_android-5750
mobmail_android-5782
mobmail_android-5751
mobmail_android-5780
mobmail_android-5754
mobmail_android-5783
mobmail_android-5786
mobmail_android-5753
mobmail_android-5756
mobmail_android-5752
mobmail_android-5339
mobmail_android-5784
mobmail_android-5786
mobmail_android-5340
mobmail_android-5757
mobmail_android-5422
mobmail_android-5350
mobmail_android-5395
mobmail_android-5351
mobmail_android-5400
mobmail_android-5421
mobmail_android-5344
mobmail_android-5393
mobmail_android-5423
mobmail_android-5435
mobmail_android-5434
mobmail_android-5436
mobmail_android-5462
mobmail_android-5790
mobmail_android-5437
mobmail_android-5438
mobmail_android-5440
mobmail_android-5439
mobmail_android-5453
mobmail_android-5459
mobmail_android-5460
mobmail_android-3343
mobmail_android-3447
mobmail_android-5441
mobmail_android-3406
mobmail_android-2067
mobmail_android-2159
mobmail_android-1932
mobmail_android-1101
mobmail_android-3914
mobmail_android-2083
mobmail_android-3412
mobmail_android-2087
mobmail_android-5158
mobmail_android-2079
mobmail_android-3416
mobmail_android-3709
mobmail_android-3711
mobmail_android-5027
mobmail_android-3712
mobmail_android-5613
mobmail_android-3710
mobmail_android-5376
mobmail_android-2078
mobmail_android-2009
mobmail_android-2094
mobmail_android-3418
mobmail_android-2079
mobmail_android-3415
mobmail_android-2093
mobmail_android-5354
mobmail_android-2091
mobmail_android-2288
mobmail_android-3413
mobmail_android-5376
mobmail_android-5732
mobmail_android-3523
mobmail_android-3505
mobmail_android-3528
mobmail_android-5414
mobmail_android-5415
mobmail_android-5352
mobmail_android-5044
mobmail_android-3408
mobmail_android-4445
mobmail_android-5345
mobmail_android-5856
mobmail_android-3328
mobmail_android-3538
mobmail_android-3409
mobmail_android-5329
mobmail_android-5404
mobmail_android-5330
mobmail_android-5330
mobmail_android-5789
mobmail_android-5482
mobmail_android-5508
mobmail_android-5405
mobmail_android-5639
mobmail_android-5640
mobmail_android-5736
mobmail_android-5734
mobmail_android-3714
mobmail_android-5788
mobmail_android-4068
mobmail_android-3707
mobmail_android-4075
mobmail_android-5032
mobmail_android-4168
mobmail_android-2433
mobmail_android-4303
mobmail_android-5097
mobmail_android-4304
mobmail_android-4992
mobmail_android-5117
mobmail_android-4894
mobmail_android-5128
mobmail_android-2063
mobmail_android-2092
mobmail_android-2089
mobmail_android-5221
mobmail_android-5130
mobmail_android-2085
mobmail_android-2088
mobmail_android-3411
mobmail_android-3417
mobmail_android-5220
mobmail_android-2063
mobmail_android-2086
mobmail_android-3380
mobmail_android-2059
mobmail_android-3390
mobmail_android-3421
mobmail_android-3391
mobmail_android-3394
mobmail_android-1924
mobmail_android-3395
mobmail_android-3394
mobmail_android-2053
mobmail_android-3396
mobmail_android-2054
mobmail_android-3398
mobmail_android-3400
mobmail_android-2441
mobmail_android-4362
mobmail_android-4474
mobmail_android-4475
mobmail_android-5710
mobmail_android-5037
mobmail_android-5041
mobmail_android-5053
mobmail_android-5711
mobmail_android-5713
mobmail_android-5714
mobmail_android-5715
mobmail_android-5716
mobmail_android-5712
mobmail_android-5717
mobmail_android-2110
mobmail_android-1572
mobmail_android-3492
mobmail_android-2161
mobmail_android-3490
mobmail_android-5718
mobmail_android-3567
mobmail_android-2115
mobmail_android-3474
mobmail_android-2292
mobmail_android-3474
mobmail_android-3494
mobmail_android-3493
mobmail_android-3496
mobmail_android-2115
mobmail_android-3497
mobmail_android-3499
mobmail_android-2308
mobmail_android-2308
mobmail_android-5118
mobmail_android-3913
mobmail_android-3495
mobmail_android-4441
mobmail_android-5320
mobmail_android-3510
mobmail_android-5322
mobmail_android-2282
mobmail_android-2118
mobmail_android-2120
mobmail_android-3524
mobmail_android-3524
mobmail_android-3522
mobmail_android-5045
mobmail_android-5217
mobmail_android-5326
mobmail_android-5516
mobmail_android-5328
mobmail_android-5523
mobmail_android-3525
mobmail_android-5522
mobmail_android-5524
mobmail_android-5525
mobmail_android-5527
mobmail_android-5526
mobmail_android-5532
mobmail_android-5534
mobmail_android-5535
mobmail_android-5537
mobmail_android-5544
mobmail_android-5545
mobmail_android-5553
mobmail_android-5556
mobmail_android-5559
mobmail_android-5567
mobmail_android-5569
mobmail_android-5570
mobmail_android-5374
mobmail_android-5569
mobmail_android-5579
mobmail_android-5590
mobmail_android-5643
mobmail_android-5584
mobmail_android-5641
mobmail_android-5644
mobmail_android-5645
mobmail_android-5650
mobmail_android-5655
mobmail_android-5662
mobmail_android-5651
mobmail_android-5686
mobmail_android-5685
mobmail_android-5687
mobmail_android-5688
mobmail_android-5695
mobmail_android-5696
mobmail_android-5697
mobmail_android-5698
mobmail_android-5689
mobmail_android-5701
mobmail_android-5702
mobmail_android-5704
mobmail_android-5705
mobmail_android-5708
mobmail_android-1390
mobmail_android-4086
mobmail_android-4080
mobmail_android-4082
mobmail_android-4083
mobmail_android-4087
mobmail_android-4085
mobmail_android-4084
mobmail_android-4088
mobmail_android-4089
mobmail_android-4091
mobmail_android-4093
mobmail_android-4092
mobmail_android-1726
mobmail_android-2265
mobmail_android-4029
mobmail_android-4355
mobmail_android-1397
mobmail_android-2163
mobmail_android-2172
mobmail_android-4031
mobmail_android-2173
mobmail_android-1428
mobmail_android-6055
mobmail_android-2174
mobmail_android-103
mobmail_android-1411
mobmail_android-1386
mobmail_android-2425
mobmail_android-74
mobmail_android-2446
mobmail_android-2184
mobmail_android-6055
mobmail_android-85
mobmail_android-1418
mobmail_android-1934
mobmail_android-5642
mobmail_android-4974
mobmail_android-5840
mobmail_android-2185
mobmail_android-5844
mobmail_android-1436
mobmail_android-3289
mobmail_android-5835
mobmail_android-5829
mobmail_android-2178
mobmail_android-47
mobmail_android-2099
mobmail_android-3882
mobmail_android-5830
mobmail_android-3884
mobmail_android-5846
mobmail_android-2100
mobmail_android-2106
mobmail_android-2187
mobmail_android-6055
mobmail_android-2107
mobmail_android-2446
mobmail_android-2425
mobmail_android-37
mobmail_android-4978
mobmail_android-2108
mobmail_android-4097
mobmail_android-5030
mobmail_android-4098
mobmail_android-4447
mobmail_android-6055
mobmail_android-1874
mobmail_android-4977
mobmail_android-5263
mobmail_android-4451
mobmail_android-4448
mobmail_android-2428
mobmail_android-5826
mobmail_android-5827
mobmail_android-6055
mobmail_android-2432
mobmail_android-4099
mobmail_android-6055
mobmail_android-2436
mobmail_android-1726
mobmail_android-1564
mobmail_android-2439
mobmail_android-4029
mobmail_android-4030
mobmail_android-5335
mobmail_android-638
mobmail_android-4031
mobmail_android-1571
mobmail_android-2445
mobmail_android-2453
mobmail_android-4032
mobmail_android-3268
mobmail_android-3637
mobmail_android-4071
mobmail_android-4072
mobmail_android-3643
mobmail_android-2376
mobmail_android-6055
mobmail_android-3635
mobmail_android-3483
mobmail_android-105
mobmail_android-3663
mobmail_android-1654
mobmail_android-3664
mobmail_android-2390
mobmail_android-5323
mobmail_android-105
mobmail_android-90
mobmail_android-5324
mobmail_android-1543
mobmail_android-125
mobmail_android-88
mobmail_android-4393
mobmail_android-124
mobmail_android-5340
mobmail_android-2024
mobmail_android-5341
mobmail_android-2164
mobmail_android-4491
mobmail_android-2022
mobmail_android-4674
mobmail_android-3886
mobmail_android-4876
mobmail_android-2444
mobmail_android-4903
mobmail_android-5150
mobmail_android-3547
mobmail_android-5337
mobmail_android-3930
mobmail_android-4580
mobmail_android-4839
mobmail_android-4840
mobmail_android-4841
mobmail_android-4918
mobmail_android-4919
mobmail_android-5347
mobmail_android-4478
mobmail_android-4359
mobmail_android-4477
mobmail_android-4390
mobmail_android-4479
mobmail_android-4614
mobmail_android-2389
mobmail_android-3381
mobmail_android-2443
mobmail_android-3697
mobmail_android-105
mobmail_android-3978
mobmail_android-4917
mobmail_android-5145
mobmail_android-3248
mobmail_android-4938
mobmail_android-3288
mobmail_android-4917
mobmail_android-3248
mobmail_android-3978
mobmail_android-4446
mobmail_android-482
mobmail_android-3981
mobmail_android-3428
mobmail_android-5146
mobmail_android-2383
mobmail_android-4450
mobmail_android-845
mobmail_android-3982
mobmail_android-849
mobmail_android-5106
mobmail_android-4461
mobmail_android-3983
mobmail_android-855
mobmail_android-3984
mobmail_android-5112
mobmail_android-3985
mobmail_android-5149
mobmail_android-486
mobmail_android-926
mobmail_android-937
mobmail_android-489
mobmail_android-5156
mobmail_android-4498
mobmail_android-951
mobmail_android-5114
mobmail_android-5166
mobmail_android-4001
mobmail_android-4500
mobmail_android-1029
mobmail_android-5119
mobmail_android-5167
mobmail_android-3249 
mobmail_android-495
mobmail_android-4452
mobmail_android-4501
mobmail_android-513
mobmail_android-4453
mobmail_android-5171
mobmail_android-512
mobmail_android-4502
mobmail_android-4454
mobmail_android-1036
mobmail_android-952
mobmail_android-5169
mobmail_android-4455
mobmail_android-961
mobmail_android-4016
mobmail_android-4456
mobmail_android-2387
mobmail_android-973
mobmail_android-4457
mobmail_android-4503
mobmail_android-2388
mobmail_android-3694
mobmail_android-4121
mobmail_android-4122
mobmail_android-3436
mobmail_android-5225
mobmail_android-4504
mobmail_android-522
mobmail_android-3437
mobmail_android-4124
mobmail_android-4125
mobmail_android-4505
mobmail_android-3440
mobmail_android-976
mobmail_android-1058
mobmail_android-544
mobmail_android-1008
mobmail_android-4136
mobmail_android-1062
mobmail_android-3695
mobmail_android-1811
mobmail_android-4140
mobmail_android-4507
mobmail_android-4141
mobmail_android-1012
mobmail_android-1071
mobmail_android-4137
mobmail_android-3687
mobmail_android-4836
mobmail_android-4443
mobmail_android-1916
mobmail_android-4892
mobmail_android-1074
mobmail_android-3691
mobmail_android-3692
mobmail_android-2006
mobmail_android-3693
mobmail_android-4444
mobmail_android-4897
mobmail_android-1021
mobmail_android-2363
mobmail_android-1027
mobmail_android-2368
mobmail_android-1017
mobmail_android-2384
mobmail_android-4904
mobmail_android-3699
mobmail_android-2373
mobmail_android-3700
mobmail_android-2374
mobmail_android-2386
mobmail_android-3937
mobmail_android-1090
mobmail_android-3963
mobmail_android-1104
mobmail_android-3964
mobmail_android-5342
mobmail_android-1104
mobmail_android-2385
mobmail_android-5145
mobmail_android-5146
mobmail_android-4917
mobmail_android-5149
mobmail_android-1114
mobmail_android-5156
mobmail_android-3968
mobmail_android-5166
mobmail_android-5167
mobmail_android-3971
mobmail_android-5171
mobmail_android-3973
mobmail_android-5176
mobmail_android-5188
mobmail_android-5199
mobmail_android-5200
mobmail_android-5211
mobmail_android-5212
mobmail_android-5201
mobmail_android-5213
mobmail_android-3973
mobmail_android-5214
mobmail_android-4959
mobmail_android-5260
mobmail_android-6055
mobmail_android-3977
mobmail_android-4986
mobmail_android-4988
mobmail_android-5868
mobmail_android-5025
mobmail_android-3965
mobmail_android-3969
mobmail_android-3962
mobmail_android-5080
mobmail_android-5123
mobmail_android-5120
mobmail_android-5125
mobmail_android-5124
mobmail_android-5079
mobmail_android-5143
mobmail_android-5052
mobmail_android-4867
mobmail_android-4866
mobmail_android-5028
mobmail_android-4873
mobmail_android-760
mobmail_android-762
mobmail_android-4033
mobmail_android-4874
mobmail_android-770
mobmail_android-799
mobmail_android-4872
mobmail_android-809
mobmail_android-4038
mobmail_android-4941
mobmail_android-811
mobmail_android-2213
mobmail_android-1907
mobmail_android-1907
mobmail_android-1818
mobmail_android-822
mobmail_android-4942
mobmail_android-823
mobmail_android-4005
mobmail_android-3291
mobmail_android-3506
mobmail_android-824
mobmail_android-3887
mobmail_android-1867
mobmail_android-4009
mobmail_android-4129
mobmail_android-1869
mobmail_android-4011
mobmail_android-4012
mobmail_android-4428
mobmail_android-1870
mobmail_android-4429
mobmail_android-4014
mobmail_android-1872
mobmail_android-4015
mobmail_android-4017
mobmail_android-4396
mobmail_android-4596
mobmail_android-4022
mobmail_android-4023
mobmail_android-4019
mobmail_android-4021
mobmail_android-4630
mobmail_android-4699
mobmail_android-4700
mobmail_android-4701
mobmail_android-4024
mobmail_android-4717
mobmail_android-4026
mobmail_android-4028
mobmail_android-4027
mobmail_android-5093
mobmail_android-5094
mobmail_android-5161
mobmail_android-5203
mobmail_android-5147
mobmail_android-5346
mobmail_android-5848
mobmail_android-5862
mobmail_android-5913
mobmail_android-4033
mobmail_android-4872
mobmail_android-6055
""".splitlines()


def prepare_cli_options():
    parser = argparse.ArgumentParser(description='Get completed testruns for project and specified date and find events from appmetrika for testruns with uuid')
    parser.add_argument('--username', required=True, help='Username for which OAuth token was received')
    parser.add_argument('--palm_token', required=True, help='TestPalm OAuth Token')
    return parser.parse_args()


def main():
    cli_args = prepare_cli_options()
    testcases_to_filter = map(lambda x: int((x.split('-')[1]).strip()), list(set(testcases_to_mark)))
    palm_api = TestPalmApi(Auth(cli_args.username, cli_args.palm_token))
    expression_dict = {
        "type": "EQ",
        "key": "attributes.{}".format(CASE_PRIORITY_ATTRIBUTE_ID),
        "value": "Business_logic"
    }
    # remove old tagged
    remove_not_covered_tag(palm_api)
    all_tcs = palm_api.get_testcases_for_project("mobmail_android", limit=10000, expression=json.dumps(expression_dict))
    tc_found = 0
    tc_ids = list()
    for tc in all_tcs:
        if tc['id'] not in testcases_to_filter and tc['status'] == 'ACTUAL' and not tc['isAutotest']:
            tc_found += 1
            tc_ids.append(str(tc['id']))
            if TAGS_ATTRIBUTE_ID not in tc['attributes']:
                tc['attributes'][TAGS_ATTRIBUTE_ID] = [ROBOT_NOT_COVERED_ATTRIB]
            else:
                tc['attributes'][TAGS_ATTRIBUTE_ID].append(ROBOT_NOT_COVERED_ATTRIB)
            if 'createdBy' not in tc:
                tc['createdBy'] = 'someone'
    print('tc_found = {}'.format(tc_found))
    print('tc_ids: {}'.format('\n'.join(tc_ids)))
    if tc_found > 0:
        patch_result = palm_api.patch_testcases_bulk("mobmail_android", all_tcs)
        print('Bulk change in testcases with result {}'.format(patch_result))


def remove_not_covered_tag(palm_api):
    expression = json.dumps({
        "type": "CONTAIN",
        "key": "attributes.{}".format(TAGS_ATTRIBUTE_ID),
        "value": 'pr_robot_not_covered'
    })
    all_tcs = palm_api.get_testcases_for_project("mobmail_android", limit=1500, expression=expression)
    for tc in all_tcs:
        if TAGS_ATTRIBUTE_ID in tc['attributes']:
            attrib = tc['attributes'][TAGS_ATTRIBUTE_ID]
            if len(attrib) > 0 and ROBOT_NOT_COVERED_ATTRIB in attrib:
                print('removing attribute from testcase {}'.format(tc))
                tc['attributes'][TAGS_ATTRIBUTE_ID].remove(ROBOT_NOT_COVERED_ATTRIB)
                patch_result = palm_api.patch_testcases("mobmail_android", tc)
                print('removed attribute from testcase {} with result {}'.format(tc, patch_result))


if __name__ == "__main__":
    main()
