import os
from dataclasses import dataclass

OAUTH_TOKEN_TESTPALM = os.environ['OAUTH_TOKEN_TESTPALM']
OAUTH_TOKEN_YT = os.environ['OAUTH_TOKEN_YT']
OAUTH_TOKEN_STARTREK = os.environ['OAUTH_TOKEN_STARTREK']
OAUTH_TOKEN_YQL = os.environ['OAUTH_TOKEN_YQL']


@dataclass(frozen=True)
class Query:
    get_bugs_open_with_resolution_or_closed: str = 'Queue: {queue} AND Type: Bug AND (Status: Open ' \
                                                   'AND Resolution: !empty() OR Status: Closed) ' \
                                                   'AND Updated: >= {start_ts} AND Updated: <= {end_ts}'


@dataclass(frozen=True)
class YtTablePath:
    table_path: str = '//home/mailfront/qa/fanem/testpalm/'
    case_status_in_run: str = table_path + 'case_status_in_run'
    linked_bugs: str = table_path + 'linked_bugs'


@dataclass(frozen=True)
class LoggerConfig:
    format: str = u'%(asctime)s [%(levelname)s] %(module)s: %(message)s'
    name: str = 'assessor_quality_logger'


@dataclass(frozen=True)
class YqlQuery:
    delete_duplicates: str = """
    USE hahn;
    PRAGMA yt.Pool = "sherlock";
    INSERT INTO `{table_path}` WITH TRUNCATE
    SELECT *
    FROM (
        SELECT MAX_BY(TableRow(), `st_issue_updated_at`)
        FROM `{table_path}`
        GROUP BY testcase_id, project, st_issue_id
    )
    FLATTEN COLUMNS;
    """
