# -*- coding: utf-8 -*-
import logging
from dataclasses import fields
from yql.api.v1.client import YqlClient
from testpalm_project import TestPalmProject
from yt_client import YTClient
from helpers import build_testpalm_filters, collect_testcases_data, delete_today_rows
from constants import LoggerConfig, Project, AutomationData, YtTablePath, OAUTH_TOKEN_YQL

logger = logging.getLogger(LoggerConfig.name)
logging.basicConfig(format=LoggerConfig.format, level=logging.INFO)


def main():
    projects = fields(Project)
    testpalm_filters = build_testpalm_filters()
    yt_client = YTClient()
    yql_client = YqlClient(token=OAUTH_TOKEN_YQL)
    delete_today_rows(yql_client, table_path=YtTablePath.automation_status)

    for project_fields in projects:
        project = project_fields.default
        project_name = project_fields.name
        logger.info(f'Count testcases for {project_name} project')
        testpalm_project = TestPalmProject(project)
        testcases_data = collect_testcases_data(testpalm_project, project_name, testpalm_filters[project_name])
        logger.info(f'Data for project "{project_name}": {testcases_data}')
        yt_client.schema = AutomationData
        yt_client.table_path = YtTablePath.automation_status
        yt_client.create_table_if_needed_and_write(testcases_data)


if __name__ == '__main__':
    main()
