from dataclasses import fields
from typing import Dict
from constants import OAUTH_TOKEN_YT
import yt.wrapper as yt


class YTClient:
    def __init__(self, auth=OAUTH_TOKEN_YT, cluster='hahn'):
        self.__auth = auth
        self.__cluster = cluster
        self.__table_path = None
        self.__schema = None
        yt.config['proxy']['url'] = self.__cluster
        yt.config['token'] = self.__auth

    @property
    def cluster(self) -> str:
        return self.__cluster

    @cluster.setter
    def cluster(self, new_cluster: str) -> None:
        self.__cluster = new_cluster

    @property
    def table_path(self) -> str:
        return self.__table_path

    @table_path.setter
    def table_path(self, new_table_path: str) -> None:
        self.__table_path = new_table_path

    @property
    def schema(self) -> str:
        return self.__schema

    @schema.setter
    def schema(self, dto):
        dto_fields = fields(dto)
        python_type_to_yt_type: Dict[str, str] = {
            'int': 'int64',
            'str': 'string',
            'bool': 'boolean'
        }
        self.__schema = list(
            map(lambda x: {'name': x.name, 'type': python_type_to_yt_type[x.type.__name__]}, dto_fields))

    def create_table_if_needed_and_write(self, data):
        yt.create('table', path=self.table_path, attributes={"schema": self.schema}, ignore_existing=True)
        yt.write_table(yt.TablePath(self.table_path, append=True),
                       data,
                       format=yt.JsonFormat(attributes={"encode_utf8": False}))
