# -*- coding: utf-8 -*-
from __future__ import unicode_literals
import json
import yaml
import requests
from constants import CHAINS, USELESS_EVENTS, TESTPALM_TOKEN, TESTPALM_BASE_URL, TESTPALM_PATH, TESTPALM_DEST_PROJECT
# import yt.wrapper as yt
# yt.config['proxy']['url'] = 'hahn'
# def upload_yaml_to_yt(file, path):
#     with open(file, 'r') as f:
#         data = json.loads(json.dumps(yaml.safe_load(f)))
#     yt.write_table(path, data, format=yt.JsonFormat(attributes={"encode_utf8": False}))


def convert_to_json(file):
    with open(file, 'r') as f:
        data = json.loads(json.dumps(yaml.safe_load(f)))
    return data


def filter_chains(chains):
    filtered_chains = []
    for chain in chains:
        filtered_chains.append([i for i in chain if i not in USELESS_EVENTS])
    return filtered_chains


def create_tc(chain, actions, count):
    test_case = {"name": "Пользовательский сценарий №" + str(count),
                 "status": "actual",
                 "stepsExpects": []}
    for event in chain:
        match = list(filter(lambda a: a['event'] == event, actions))
        test_case['stepsExpects'].append({'step': match[0]['action'] if match else event})
    return test_case


def post_tc(tc):
    url = TESTPALM_BASE_URL + TESTPALM_PATH + TESTPALM_DEST_PROJECT
    header = {'Authorization': 'OAuth ' + TESTPALM_TOKEN, 'Content-Type': 'application/json'}
    r = requests.post(url, data=json.dumps(tc), headers=header)
    print(r.status_code)
    if r.status_code != 200:
        print(r.text)
    return r


def main():
    actions = convert_to_json("actionByEvent.yaml")
    filtered_chains = filter_chains(CHAINS)

    count = 1
    for chain in filtered_chains:
        tc = create_tc(chain, actions, count)
        print(tc)
        post_tc(tc)
        count += 1


if __name__ == '__main__':
    main()
