#
# python3 create_folder.py -user 'test.fanem' -pwd 'qwerty123asd' -num 10
#

from __future__ import unicode_literals
import argparse
import requests
import string
import random
from urllib3.util.retry import Retry
from requests.adapters import HTTPAdapter

OAUTH_BASE_URL = 'https://oauth.yandex.ru/token'
API_BASE_URL = 'https://mail.yandex.ru/api/mobile/'
CREATE_FOLDER_API_METHOD = 'v1/create_folder'
CREATE_LABEL = 'v1/create_label'
DELETE_LABEL = 'v1/delete_label'

def handle_options():
    parser = argparse.ArgumentParser()
    parser.add_argument("-user", "--username", dest="username")
    parser.add_argument("-pwd", "--password", dest="password")
    parser.add_argument("-num", "--folder_number", dest="folder_number")
    return parser


def connect():
    r = requests.Session()
    retries = Retry(total=5, backoff_factor=0.1, status_forcelist=[500, 502, 503, 504])
    r.mount('https://', HTTPAdapter(max_retries=retries))
    return r


def get_oauth(username, password):
    url = OAUTH_BASE_URL
    data = {
        "grant_type": "password",
        "username": username,
        "password": password,
        "client_id": "e7618c5efed842be839cc9a580be94aa",
        "client_secret": "81a97a4e05094a4c96e9f5fa0b21f794"
    }
    r = connect().post(url, data=data)
    return r.json()["access_token"]


def create_folder(token, name, fid=None, subfolder=False):
    url = API_BASE_URL + CREATE_FOLDER_API_METHOD
    data = {"name": name}
    header = {'Authorization': 'OAuth ' + token}

    if subfolder:
        data['parent_fid'] = fid

    r = connect().post(url, headers=header, data=data)

    response = r.json()

    if response['status']['status'] == 1:
        return response['fid']
    else:
        print(response['status']['phrase'])
        exit()


def create_label(token, color, label_name):
    url = API_BASE_URL + CREATE_LABEL
    header = {'Authorization': 'OAuth ' + token}
    data = {
        "color": color,
        "name": label_name
     }
    print(data)
    r = connect().post(url, headers=header, data=data)
    print(r.json())
    return r.json()


def delete_label(token, lid):
    url = API_BASE_URL + DELETE_LABEL
    header = {'Authorization': 'OAuth ' + token}
    data = {
        "lid": lid
    }
    r = connect().post(url, headers=header, data=data)
    print(r.json())
    return r.json()


def random_generator(size=10, chars=string.ascii_letters + string.digits):
    return ''.join(random.choice(chars) for _ in range(size))


def main():
    # args = handle_options().parse_args()
    # username = args.username
    # password = args.password
    # folder_number = int(args.folder_number)
    #
    # token = get_oauth(username, password)
    #
    # for folder_name in range(folder_number):
    #     fid = create_folder(token, random_generator())
    #
    # print('All folders created'

    username = 'yndx-labels'
    password = 'qwerty123asdf'
    token = get_oauth(username, password)
    colors = ["31c73b", "7cc3c4", "5a8eff", "ba99ff", "a8bcce", "c1be00", "f99000", "ff8985",
     "28a931", "67a3a4", "5080e7", "a488e2", "8e9faf", "a19f00", "db7f00", "ff3f30",
     "1d8925", "508182", "456ec8", "8e75c4", "73818e", "807e00", "bb6c00", "f32300",
     "136619", "395e5f", "385ca8", "7760a4", "57616c", "5c5a00", "9c5800", "d51e00"]

    strings = ["ČčĎďÉéŤťÚúŮůÝýŽ", "غةّد للأصوات في", "çĞğÖöŞşÜü",
               "בהתאם צון לדייק", "又稱萬國音標國際語音學學會設", "ფონეტიკური", "ΎΏΐΔΘΛΞΪάΰβλθζδ", "₤₥₦₩€₮₳", "£¤¥¦§©«®°±µ",
               "ðñôø÷ýþÿ", "ƊƌƍƏƐƑƓƔ", "ᴟᴓᴔᴕᴥᴧᴞ", "⁺⁻ⁿ₊₠₡", "₡₢₣₤₦₥₧₩₪₱₲", "∏∑√∞∟∩", "①│┐┘"]
    name = '1'
    for i in range(0, 13):
        create_label(token, color=colors[i], label_name=name)
        name += str(int(name[-1]) + 1)
        print(name)
    # count = 0
    # for string in strings:
    #     create_label(token, color=colors[count], label_name=string)
    #     count += 1

    # for lid in range(53, 84):
    #     delete_label(token, lid)


if __name__ == '__main__':
    main()
