# Общее
Перед использованием нужно установить

* Клиент TestPalm API

  `pip3 --no-cache-dir install -i https://pypi.yandex-team.ru/simple yandex_tp_api_client`

* Клиент Startrek API

  `pip3 install -i https://pypi.yandex-team.ru/simple/ startrek_client`

Скрипт для запуска тестирования асессорами. Для работы скрипта необходимы три файла:

* `data.py` - файл с тестовыми данными
* `test_suites.yaml` - файл с ранами
* `booking.py` - логика бронирования

### Запуск скрипта
У запуска есть 2 параметра:
1. `-r` или `--run_process` - флаг, который создает бронь и запускает процесс в хитмане (версия в пальме и тикет в стартреке уже созданы)
2. `-b` или `--booking` - флаг, в который можно передать id регулярной брони (новая бронь создана не будет)

Примеры:

`python3 start_assessor.py` - создает версию и раны в TP, оставляет комментарий в тестируемом тикете в стартреке, создает бронь и запускает процесс в Hitman

`python3 start_assessor.py -r` - создает бронь и запускает процесс в Hitman

`python3 start_assessor.py -b 29733` - создает версию и раны в TP, оставляет комментарий в тестируемом тикете в стартреке, запускает процесс в Hitman с переданным в параметре номером брони

`python3 start_assessor.py -b 29733 -r` - запускает процесс в Hitman с переданным в параметре номером брони

### Входные данные

#### Перед первым запуском необходимо заполнить поля в файле `data.py`:
* токен для Startrek API `StartrekData.token`
* токен для Hitman API `HitmanData.token`
* токен для Testpalm API `TestpalmData.token`
* логин `RunData.login`

Остальные поля, например, `StartrekData.queue`, `TestpalmData.project` и тд., можно менять, если есть необходимость.

#### Перед каждым запуском скрипта необходимо проверить корректность данных `RunData` в файле `data.py`:
* версия приложений для тестирования `app_version`
* суффикс названия версии в пальме `part`
* корректность ссылки на билд `link_to_build`
* тикет на тестирование версии в трекере `ticket_for_testing`
* спецусловия прохождения запуска для асессоров `annotation`
* набор запускаемых сьютов `scenario`
* платформа, на которой  запущено тестирование `platform`

Для работы скрипта необходимо заполнить следующие поля:

###  Заполнение файла `test_suites.yaml`

Каждый ран состоит из следующих частей:

* `run_name` - имя рана 

* `tags` - теги (например, тег `notSuitableForFarm` запрещает прохождение ранов на ферме)

* `environment` - окружение, в котором его необходимо выполнить

* `key` - id-шник рана (берется из URL)