import os
from dataclasses import dataclass
from enum import Enum


class Platform(Enum):
    iOS: str = 'iOS'
    Android: str = 'Android'


@dataclass()
class RunData:
    login: str = 'fanem'
    ticket_for_testing: str = 'PAYMENTSDK-267'
    annotation: str = f"""
    Билд 1.0.0 нужно скачать с https://beta.m.soft.yandex.ru .
    Внимательно прочтите инструкцию - https://wiki.yandex-team.ru/eva/testing/projects/paymentsdk/instruction
    """
    link_to_build: str = 'https://beta.m.soft.yandex.ru/description?app=paymentsdk&platform_shortcut=iphoneos&branch=master-for-migration'
    app_version: str = '1.0.0'
    scenario: str = 'testing'
    part: str = '0_test_3'
    instruction: str = 'https://wiki.yandex-team.ru/eva/testing/Projects/payment_sdk/'
    platform: str = Platform.iOS


@dataclass()
class BookingData:
    quota_code: str = 'qs_testpalm_separate_payment_sdk_ru'
    max_quota: int = 5
    max_duration: int = 10
    is_night_run: bool = False


@dataclass()
class StartrekData:
    token: str = os.environ['OAUTH_TOKEN_STARTREK']
    base_url: str = 'https://st-api.yandex-team.ru'
    assessors_queue: str = 'PAYASSESSORS'
    queue: str = 'PAYMENTSDK'
    login: str = RunData.login


@dataclass()
class HitmanData:
    token: str = os.environ['OAUTH_TOKEN_HITMAN']
    base_url: str = 'https://hitman.yandex-team.ru/'
    process_code: str = 'payment_sdk'
    login: str = RunData.login
    write_result_to_ticket: str = 'false'


@dataclass()
class TestpalmData:
    token: str = os.environ['OAUTH_TOKEN_TESTPALM']
    base_url: str = 'https://testpalm.yandex-team.ru/'
    project: str = 'payment_sdk'
    login: str = RunData.login


@dataclass()
class Data:
    run_data: RunData = RunData
    startrek_data: StartrekData = StartrekData
    hitman_data: HitmanData = HitmanData
    testpalm_data: TestpalmData = TestpalmData
    bookeing_data: BookingData = BookingData
