import requests
from pyyamail.constants import CLIENT_ID, CLIENT_SECRET, OAUTH_SERVER
from itertools import chain

__author__ = 'karlicos'


def get_oauth_token(username: str, password: str) -> str:
    payload = {
        'grant_type'   : 'password',
        'username'     : username,
        'password'     : password,
        'client_id'    : CLIENT_ID,
        'client_secret': CLIENT_SECRET
    }
    r = requests.post(OAUTH_SERVER, data = amp_separated(payload))
    j = r.json()
    return j['access_token']


def amp_separated(d: dict) -> str:
    return '&'.join(k + "=" + v for k, v in d.items())

def comma_separated(l: list) -> str:
    return ','.join(i for i in l)

def make_dict_filter(keys: list):
    return lambda d: {k: d[k] for k in keys if k in d}

def flatmap(f, items):
    return chain.from_iterable(map(f, items))