import argparse
import logging
from time import sleep

from yql.api.v1.client import YqlClient
from datetime import datetime, timedelta
from yql.config import config

logging.basicConfig(level=logging.INFO)


def compute(date_from, date_to):
    current = to_date(date_from)
    last = to_date(date_to)
    while current <= last:
        start(current)
        current += timedelta(days=1)
        if current <= last:
            sleep(60)


def start(date):
    yql = 'USE hahn;\n' \
          '$appmetrika = (SELECT UUID, DeviceID, EventName, EventValue FROM RANGE([home/logfeller/logs/metrika-mobile-log/1d], "$date_from", "$date_to") WHERE APIKey = "29733");\n' \
          '$blocked_notifications_device_ids = (SELECT DISTINCT(DeviceID) FROM $appmetrika WHERE EventName = "push-not-permitted-by-user");\n' \
          '$active_device_ids = (SELECT DISTINCT(DeviceID) FROM [home/logfeller/logs/metrika-mobile-log/1d/$date_to] WHERE APIKey = "29733" AND CAST(OSApiLevel AS Int) >= 11 AND EventName = "app_start" AND DeviceID NOT IN $blocked_notifications_device_ids);\n' \
          '$active_ok_sessions = (SELECT String::ToLower(String::ReplaceAll(DeviceID, "-", "")) AS session FROM $active_device_ids);\n' \
          '$xiva = (SELECT * FROM [logs/xivahub-log/1d/$date_from]);\n' \
          '$send = (SELECT transit_id, session FROM $xiva WHERE group = "notifications" AND service = "apns_queue" AND bright = "true" AND status = "conveyed");\n' \
          '$send = (SELECT DISTINCT(transit_id) FROM $send WHERE session IN $active_ok_sessions);\n' \
          '$received = (SELECT Yson::LookupString(Yson::ParseJson(EventValue), "transit-id") as transit_id FROM $appmetrika WHERE EventName = "push-received");\n' \
          '$received = (SELECT DISTINCT(transit_id) FROM $received);\n' \
          '$received_count = (SELECT COUNT(*) FROM $send WHERE transit_id IN $received);\n' \
          '$send_count = (SELECT COUNT(*) FROM $send);\n' \
          'UPSERT INTO stat.[Mail/Xiva/ApnsQueue/daily]\n' \
          'SELECT "$date_from" as fielddate, $received_count as received_count, $send_count as sent_count, 100.0 * $received_count / $send_count as delivery_rate;'

    query = yql.replace('$date_from', to_str(date)).replace('$date_to', to_str(date + timedelta(days=1)))

    request = YqlClient().query(query)
    request.run()
    logging.info('Started YQL: ' + web_url(request))


def execute(*queries):
    client = YqlClient()
    results = []
    for query in queries:
        request = client.query(query)
        result = request.run()
        logging.info('Started YQL: ' + web_url(request))
        results.append(result)

    for result in results:
        result.wait_progress()
        if result.status == 'ERROR':
            raise Exception('YQL finished with error!')

    tables = list(map(lambda result: result.table.rows, results))
    return tables


def web_url(yql_query):
    return '{}/Operations/{}'.format(config.web_url, yql_query.operation_id)


def to_date(ymd):
    return datetime.strptime(ymd, '%Y-%m-%d').date()


def to_str(date):
    return date.strftime('%Y-%m-%d')


def main():
    parser = argparse.ArgumentParser(description='Find info about user pushes')
    parser.add_argument('--date-from', required=True, help='From date to compute')
    parser.add_argument('--date-to', required=True, help='To date to compute')
    args = parser.parse_args()
    date_from = args.date_from.split('T')[0]
    date_to = args.date_to.split('T')[0]

    compute(date_from, date_to)


if __name__ == '__main__':
    main()
