import argparse
import logging
from time import sleep

from yql.api.v1.client import YqlClient
from datetime import datetime, timedelta
from yql.config import config

logging.basicConfig(level=logging.INFO)


def compute(date_from, date_to):
    current = to_date(date_from)
    last = to_date(date_to)
    while current <= last:
        start(current)
        current += timedelta(days=1)
        if current <= last:
            sleep(60)


def start(date):
    yql = """PRAGMA yt.Pool = 'sherlock';
USE hahn;

$get_uid_from_env_script = @@
import json
from yql.typing import *

def get_uid_from_env(keys_string: Optional[String], values_string: Optional[String]) -> Optional[String]:
    if not keys_string or not values_string:
        return None
    keys = json.loads(keys_string)
    values = json.loads(values_string)
    try:
        uid_index = keys.index('uid')
        return values[uid_index]
    except:
        return None
@@;
$get_uid_from_env = Python3::get_uid_from_env($get_uid_from_env_script);

$get_uid_from_value_script = @@
import json
from yql.typing import *

def get_uid_from_value(value_string: Optional[String]) -> Optional[String]:
    if not value_string:
        return None
    try:
        event_data = json.loads(value_string)
    except:
        return None
    bundle = event_data.get("data", None)
    if not bundle:
        return None

    uid = None
    try:
        parts = bundle.split("Bundle[{", 1)[1].split("}]", 1)[0].split(", ")
        for part in parts:
            keyvalue = part.split("=", 1)
            key = keyvalue[0]
            if key == "uid":
                uid = keyvalue[1] if len(keyvalue) > 1 else None
    except LookupError:
        pass

    return uid
@@;
$get_uid_from_value = Python::get_uid_from_value($get_uid_from_value_script);

$xivahub = (SELECT * FROM `logs/xivahub-log/1d/$date_to` WHERE service = "mail" AND uid IS NOT NULL);
$active_xiva_uids = (SELECT DISTINCT uid FROM $xivahub WHERE status = "new");
$send_push_subscriptions = (SELECT DISTINCT uid, session AS `uuid` FROM $xivahub WHERE status = "conveyed" AND platform = "fcm" AND LEN(session) > 0 AND uid IN $active_xiva_uids);

INSERT INTO @tmp1
SELECT `UUID`, EventName, EventValue, ReportEnvironment_Keys, ReportEnvironment_Values FROM RANGE(`logs/metrika-mobile-log/1d`, "$date_from", "$date_to") WHERE APIKey = "14836";
COMMIT;
$app_metrika_3d = SELECT * FROM @tmp1;

$expected_events = (SELECT $get_uid_from_env(ReportEnvironment_Keys, ReportEnvironment_Values) as uid, `UUID` AS `uuid`, EventName AS event_name FROM $app_metrika_3d);
$receiving_push_events = (SELECT $get_uid_from_value(EventValue) as uid, `UUID` as `uuid` FROM $app_metrika_3d WHERE EventName = "push_received");
-- $concat = (SELECT uid, uuid FROM CONCAT($expected_events, $receiving_push_events));
$expected_active_subscriptions = (SELECT DISTINCT uid, `uuid` FROM $expected_events WHERE uid IN $active_xiva_uids);
$unsubscribed = (SELECT uid, `uuid` FROM $expected_events WHERE event_name = "unsubscribe_from_push_scheduled");
$expected_active_subscriptions = (SELECT a.uid AS uid, a.`uuid` AS `uuid` FROM $expected_active_subscriptions AS a LEFT ONLY JOIN $unsubscribed AS b USING (uid, `uuid`));
$expected_active_subscriptions_count = (SELECT COUNT(*) FROM $expected_active_subscriptions);

$app_metrika_1d = (SELECT * FROM `logs/metrika-mobile-log/1d/$date_to` WHERE APIKey = "14836" AND `UUID` IS NOT NULL);
$receiving_push_events_1d = (SELECT $get_uid_from_value(EventValue) as uid, `UUID` as `uuid` FROM $app_metrika_1d WHERE EventName = "push_received");
$receiving_push_subscriptions = (SELECT DISTINCT uid, `uuid` FROM $receiving_push_events_1d WHERE uid IN $active_xiva_uids);
$not_receiving_push_subscriptions = (SELECT a.uid AS uid, a.`uuid` AS `uuid` FROM $expected_active_subscriptions AS a LEFT ONLY JOIN $receiving_push_subscriptions AS b USING (uid, `uuid`));
$not_receiving_push_active_subscriptions_count = (SELECT COUNT(*) FROM $not_receiving_push_subscriptions);

$not_receiving_and_not_send_subscriptions = (SELECT a.uid AS uid, a.`uuid` AS `uuid` FROM $not_receiving_push_subscriptions AS a LEFT ONLY JOIN $send_push_subscriptions AS b USING (uid, `uuid`));
$not_receiving_and_not_send_expected_subscriptions_count = (SELECT COUNT(*) FROM $not_receiving_and_not_send_subscriptions);

$not_send_expected_subscriptions = (SELECT a.uid AS uid, a.`uuid` AS `uuid` FROM $expected_active_subscriptions AS a LEFT ONLY JOIN $send_push_subscriptions AS b USING (uid, `uuid`));
$not_send_expected_active_subscriptions_count = (SELECT COUNT(*) FROM $not_send_expected_subscriptions);

UPSERT INTO stat.`Mail/Xiva/AndroidSubscriptionCover/daily`
SELECT "$date_to" as fielddate, $expected_active_subscriptions_count as total, $not_receiving_push_active_subscriptions_count as not_receiving, $not_receiving_and_not_send_expected_subscriptions_count as not_receiving_and_not_send, $not_send_expected_active_subscriptions_count as not_send;        
"""

    query = yql.replace('$date_from', to_str(date - timedelta(days=3))).replace('$date_to', to_str(date))

    request = YqlClient().query(query, syntax_version=1)
    request.run()
    logging.info('Started YQL: ' + web_url(request))


def web_url(yql_query):
    return '{}/Operations/{}'.format(config.web_url, yql_query.operation_id)


def to_date(ymd):
    return datetime.strptime(ymd, '%Y-%m-%d').date()


def to_str(date):
    return date.strftime('%Y-%m-%d')


def main():
    parser = argparse.ArgumentParser(description='Find info about user pushes')
    parser.add_argument('--date-from', required=True, help='From date to compute')
    parser.add_argument('--date-to', required=True, help='To date to compute')
    args = parser.parse_args()
    date_from = args.date_from.split('T')[0]
    date_to = args.date_to.split('T')[0]

    compute(date_from, date_to)


if __name__ == '__main__':
    main()
