import datetime
import os

from startrek_client import Startrek

from tools.release.comment_startrek import find_release_ticket

ios = {
    '3.6.0': {
        'fix_version': '3.60',
        'start': 1523653200000,
        'final': 17.1
    },
    '3.6.1': {
        'fix_version': '3.61',
        'start': 1525726800000,
        'final': 26.8
    },
    '3.6.2': {
        'fix_version': '3.62',
        'start': 1528232400000,
        'final': 28.3
    },
    '3.6.4': {
        'fix_version': '3.64',
        'start': 1530824400000,
        'final': 34.8
    },
    '3.6.5': {
        'fix_version': '3.65',
        'start': 1533848400000,
        'final': 25.5
    },
    '3.6.7': {
        'fix_version': '3.67',
        'correct_testing': True,
        'start': 1535317200000,
        'final': 39.1
    },
    '3.70': {
        'fix_version': '3.70.0',
        'start': 1537218000000,
        'final': 28.4
    },
    '3.71': {
        'fix_version': '3.71.0',
        'correct_testing': True,
        'start': 1537909200000,
        'final': 37.0
    },
    '3.72': {
        'fix_version': '3.72.0',
        'correct_testing': True,
        'start': 1541074440000,
        'final': '2018-11-27'
    },
    '3.73': {
        'fix_version': '3.73.0',
        'correct_testing': True,
        'start': 1542651420000,
        'final': '2018-12-10'
    },
    '3.74': {
        'fix_version': '3.74.0',
        'correct_testing': True,
        'start': 1544447280000,
        'final': '2018-12-20'
    },
    '3.76': {
        'fix_version': '3.76.0',
        'final': '2019-01-12'
    },
    '3.77': {
        'fix_version': '3.77.0',
        'final': '2019-01-24'
    },
    '3.78': {
        'fix_version': '3.78.0',
        'final': '2019-02-13'
    },
    '3.79': {
        'fix_version': '3.79.0',
        'final': '2019-02-27'
    },
    '3.80': {
        'fix_version': '3.80.0',
        'final': '2019-03-11'
    },
    '3.81': {
        'fix_version': '3.81.0',
        'final': '2019-03-16'
    },
    '3.82.0': {
        'final': '2019-04-08'
    },
    '3.83.0': {
        'final': '2019-04-19'
    },
    '3.84.0': {
        'final': '2019-05-29'
    },
    '3.85.0': {
        'final': '2019-06-16'
    },
    '3.86.0': {
        'final': '2019-06-26'
    },
    '3.87.0': {
        'final': '2019-07-29'
    },
    '3.88.0': {
        'final': '2019-07-13'
    }
}

android = {
    '4.2.0':{
        'start': 1527195600000,
        'final': 14.0
    },
    '4.3.0': {
        'start': 1528923600000,
        'final': 12.0
    },
    '4.3.1': {
        'start': 1531083600000,
        'final': 8.0
    },
    '4.5.0': {
        'start': 1532466000000,
        'final': 13.7
    },
    '4.7.2': {
        'fix_version': '4.7.0',
        'start': 1535662800000,
        'final': 18.0
    },
    '4.9.1': {
        'start': 1541073600000,
        'final': 31.0
    },
    '4.10.1': {
        'final': '2018-11-14'
    },
    '4.11.0': {
        'start': 1543320300000,
        'final': '2018-12-11'
    },
    '4.12.0': {
        'final': '2018-12-20'
    },
    '4.13.0': {
        'final': '2019-01-16'
    },
    '4.14.0': {
        'final': '2019-01-25'
    },
    '4.15.0': {
        'final': '2019-02-07'
    },
    '4.16.0': {
        'final': '2019-02-19'
    },
    '4.17.0': {
        'final': '2019-03-06'
    },
    '4.19.3': {
        'final': '2019-04-04'
    },
    '4.20.0': {
        'final': '2019-04-16'
    },
    '4.21.0': {
        'final': '2019-04-22'
    },
    '4.22.0': {
        'final': '2019-05-13'
    },
    '4.23.1': {
        'final': '2019-05-20'
    },
    '4.24.0': {
        'final': '2019-05-28'
    },
    '4.25.0': {
        'final': '2019-06-04'
    },
    '4.26.0': {
        'final': '2019-06-14'
    },
    '4.27.0': {
        'final': '2019-06-24'
    },
    '4.28.0': {
        'final': '2019-07-02'
    },
    '4.29.2': {
        'final': '2019-07-10'
    },
    '4.30.1': {
        'start': '2019-07-10',
        'final': '2019-07-19'
    },
    '4.31.0': {
        'start': '2019-07-25',
        'final': '2019-08-01'
    },
    '4.32.0': {
        'start': '2019-08-01',
        'final': '2019-08-06'
    },
    '4.33.1': {
        'start': '2019-08-07',
        'final': '2019-08-14'
    }
}

def to_days(duration):
    return duration.total_seconds() / (24 * 60 * 60)

def parse_startrek_date(s):
    return datetime.datetime.strptime(s, '%Y-%m-%dT%H:%M:%S.%f%z')


def find_release_tickets(config, prefix):
    startrek_token = os.environ['STARTREK_TOKEN']
    client = Startrek(token=startrek_token, useragent='python')
    for k, v in config.items():
        fix_version = v['fix_version'] if 'fix_version' in v else k
        release_ticket = find_release_ticket(client, prefix + ' ' + fix_version)

        created_at = None
        if 'start' in v:
            start = v['start']
            if isinstance(start, str):
                created_at = datetime.datetime.strptime(start, '%Y-%m-%d').astimezone()
            else:
                created_at = datetime.datetime.fromtimestamp(start / 1000).astimezone()
        else:
            for comment in release_ticket.comments:
                comment_text = comment.text
                if 'Автоматический отчет о сборке билда' in comment_text:
                    created_at = parse_startrek_date(comment.updatedAt)
                    break
        if not created_at:
            raise Exception('No start!')

        print(fix_version + ' -> ' + release_ticket.key)
        print(fix_version + f' created {created_at}')
        changes = release_ticket.changelog.get_all(sort='asc', field='status', type='IssueWorkflow')
        # if 'correct_testing' in v:
        print(f'start: {int(1000 * created_at.timestamp())}')

        final = v['final']
        if not isinstance(final, float):
            final_ts = datetime.datetime.strptime(final, '%Y-%m-%d').astimezone()
            final = to_days(final_ts - created_at)
        print(f'final: {final}')

        if True:
            for change in changes:
                to = change.fields[0]['to']
                if not to:
                    continue
                status_to = to.key
                print(change.updatedAt + ' -> ' + status_to)
                if status_to == 'testing':
                    print(fix_version + ' testing ' + change.updatedAt)
                    finish = parse_startrek_date(change.updatedAt)
                    print(f'testing: {to_days(finish - created_at)}')


def main():
    # find_release_tickets(android, 'Android')
    find_release_tickets(ios, 'iOS')


if __name__ == '__main__':
    main()
