import os

STAT_BASE_URL = 'https://upload.stat.yandex-team.ru'
STAT_DELETE = '/_api/report/delete_data/'
STAT_UPLOAD = '/_api/report/data/'
STAT_TABLE = 'Adhoc/fanem/release_quality/release_quality'
STAT_PARAMS = '?scale=d&release={}&queue=_in_table_&service=_in_table_&period=_in_table_&month=_in_table_&date_min=2019-06-01&date_max=2030-12-31'
STAT_TOKEN = os.environ['OAUTH_TOKEN_STAT']
ST_TOKEN = os.environ['OAUTH_TOKEN_STARTREK']
ST_URL = 'https://st-api.yandex-team.ru'
ST_BULK_UPDATE = '/v2/bulkchange/_update'
TIME_FORMAT = '%Y-%m-%dT%H:%M:%S'
SENDER_EMAIL = 'mobmail.reminder@yandex.ru'
SENDER_PWD = os.environ['SENDER_PWD']
SEC_IN_DAY = 86400
MIN_QUALITY = 1
MAX_QUALITY = 100
QUEUES = {
    # 'DARIA': 'Почта Веб',
    # 'QUINN': 'Почта Тач',
    'MOBILEMAIL': 'Почта Моб',
    'CHEMODAN': 'Диск Веб',
    'DISCSW': 'Диск Десктоп',
    'MOBDISK': 'Диск Моб',
    'DOCVIEWER': 'Диск Веб',
    # 'MAYA': 'Календарь',
    'PASSP': 'Паспорт',
    'MOBDEVAUTH': 'АМ',
    'DV': 'Диск Веб',
    'VAULT': 'Паспорт',
    'PLUS': 'Паспорт'
}
TOTAL = "_total_"
PERIODS = {
    'January': 'Q1',
    'February': 'Q1',
    'March': 'Q1',
    'April': 'Q2',
    'May': 'Q2',
    'June': 'Q2',
    'July': 'Q3',
    'August': 'Q3',
    'September': 'Q3',
    'October': 'Q4',
    'November': 'Q4',
    'December': 'Q4',
}
ROBOTS = [
    "robot-gerrit",
    "robot-aqua-testpers robot-aqua-testpers",
    "zomb-mobmail-qa",
]
STATUS = {
    'allTicketsTested': ["Тестирование \"тела\" релиза завершено"],
    'firstRegressionStarted': ["Приступили к первой итерации регресса"],
    'firstRegressionDone': ["Первая итерация регресса завершена"],
    'versionReadyRelease': ["Весь релиз протестирован. Релиз готов к выкатке",
                            "Весь релиз протестирован и готов к выкладке",
                            "Весь релиз протестирован и готов к выкатке"]
}
FILTER = {
    'PASSP_ISSUES': 'Queue: PASSP AND Resolution: !"Can\'t reproduce" AND Resolution: !Duplicate AND Resolution: !"Won\'t fix"'
                    'AND Resolution: !"Will Not Fix" AND Resolution: !Incomplete AND Resolution: !Invalid AND Resolution: !"Until next complaint" '
                    'AND Resolution: !"Later" AND (Deadline: today() - "1d" OR Status: changed( to: Closed date: today() - "1d" ) '
                    'OR Status: changed( to:Released date: today() - "1d")) AND (Type: Release OR "Release Type": notEmpty()) AND Components: "%Фронтенд"',
    'ALL_QUEUE_ISSUES': 'Queue: {} AND Resolution: !"Can\'t reproduce" AND Resolution: !Duplicate AND Resolution: !"Won\'t fix"'
                        'AND Resolution: !"Will Not Fix" AND Resolution: !Incomplete AND Resolution: !Invalid AND Resolution: !"Until next complaint" '
                        'AND Resolution: !"Later" AND (Deadline: today() - "1d" OR Status: changed( to: Closed date: today() - "1d" ) '
                        'OR Status: changed( to:Released date: today() - "1d")) AND (Type: Release OR "Release Type": notEmpty())',
    'FIX_VERSION': 'Queue: "{}" AND "Fix Version": "{}" AND "Key":! "{}" AND Resolution:! Duplicate AND '
                   'Resolution:! Invalid AND Resolution:! "Won\'t fix" AND Resolution:! "Will Not Fix" AND '
                   'Resolution: ! Incomplete',
    'RELEASE_TICKET_BY_VERSION': '"Queue": "{}" AND "Fix Version": "{}" AND (Type: Release OR "Release Type": notEmpty())',
    'FILL_FIELDS': 'Queue: "{}" AND (Type: Release OR "Release Type": notEmpty()) AND Created: >= 01.05.2019 AND Updated: >= today() - "1d"'
}
LEADS = {
    # 'DARIA': ['cosmopanda@yandex-team.ru'],
    # 'QUINN': ['oleshko@yandex-team.ru'],
    'MOBILEMAIL': ['olyd@yandex-team.ru', 'fanem@yandex-team.ru'],
    'CHEMODAN': ['yaroslavna@yandex-team.ru', 'nkutasova@yandex-team.ru'],
    'DISCSW': ['xiona@yandex-team.ru', 'halaukova@yandex-team.ru', 'alexbr@yandex-team.ru'],
    'MOBDISK': ['anovarov@yandex-team.ru', 'lizvad@yandex-team.ru'],
    'DOCVIEWER': ['yaroslavna@yandex-team.ru', 'nkutasova@yandex-team.ru'],
    # 'MAYA': ['olga-ganchikova@yandex-team.ru'],
    'PASSP': ['iolanta@yandex-team.ru', 'gladnik@yandex-team.ru'],
    'MOBDEVAUTH': ['oafashokov@yandex-team.ru', 'gladnik@yandex-team.ru'],
    'DV': ['yaroslavna@yandex-team.ru', 'nkutasova@yandex-team.ru'],
    'VAULT': ['gladnik@yandex-team.ru'],
    'PLUS': ['gladnik@yandex-team.ru']
}
HTML = u"""
<head>
    <meta content="text/html; charset=utf-8" http-equiv="Content-Type"/>
    <meta content="IE=edge" http-equiv="X-UA-Compatible"/>
    <meta content="width=device-width, initial scale=1.0" name="viewport"/>
</head>
<body style="background-color: #F7F7F7; margin: 0px 0px 0px 0px; min-width: 100%; padding: 0px 0px 0px 0px;">
<table bgcolor="#F7F7F7" border="0" cellpadding="0" cellspacing="0"
       style="color: #333333; font-family: sans-serif; line-height: 22px;" width="100%">
    <tr>
        <td style="padding: 0px 0px 0px 0px;">
            <center style="box-sizing: border-box; margin: 0 auto; max-width: 620px; padding: 0px 10px 0px 10px; table-layout: fixed;
                    table-layout: fixed; -webkit-text-size-adjust: 100%; -ms-text-size-adjust: 100%; box-sizing: border-box;
                    padding: 0px 10px 0px 10px; max-width: 620px; margin: 0 auto;">
                <div style="max-width: 600px;">
                    <!--[if (gte mso 9)|(IE)]>
                    <table cellpadding="0" cellspacing="0" border="0" width="600" align="center">
                        <tr>
                            <td>
                    <![endif]-->
                    <table align="center" border="0" cellpadding="0" cellspacing="0" style="color: #333333; font-family: sans-serif; line-height: 22px; max-width: 600px; width: 100%;">
                        <tr>
                            <td style="padding: 25px 0px 12px 0px;">
                                <table border="0" cellpadding="0" cellspacing="0" style="color: #333333; font-family: sans-serif; line-height: 22px; width: 100%;">
                                    <tr>
                                        <td align="left" height="32" style="height: 32px; padding: 0px 0px 0px 0px;" align="top">
                                            <img alt="Яндекс" class="logo"
                                                 src="https://avatars.mds.yandex.net/get-adv/61206/2a000001644bb535090eff58345d3f3c8041/orig"
                                                 height="27" border="0"
                                                 style="display: block; border: 0; color: #010101; font-family: sans-serif; font-size: 24px;">
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                        <tr>
                            <td style="padding: 0px 0px 0px 0px;">
                                <table border="0" cellpadding="0" cellspacing="0" style="background-color: #ffffff; color: #333333; font-family: sans-serif; line-height: 22px; width: 100%;">
                                    <tr>
                                        <td style="padding-left: 40px; padding-right: 40px; padding-bottom: 21px; padding-top: 31px;">
                                            <table border="0" cellpadding="0" cellspacing="0" style="color: #333333; font-family: sans-serif; line-height: 22px;" width="100%">
                                                <tr>
                                                    <td style="padding: 0px 0px 0px 0px; padding-bottom: 5px; text-align: left; width: 100%;">
                                                        <p style="color: #333333; font-family: Arial, sans-serif; font-size: 15px; line-height: 22px; margin: 0 0 10px 0; padding-bottom: 5px; padding-top: 5px;">
                                                            Привет!</p>
                                                        <p style="color: #333333; font-family: Arial, sans-serif; font-size: 15px; line-height: 22px; margin: 0 0 10px 0; padding-bottom: 5px; padding-top: 5px;">
                                                            Качество релиза <b>{}</b> равно {}.<br>
                                                            Убедись, пожалуйста, что поля релизного тикета <a href=https://st.yandex-team.ru/{}>{}</a> заполнены правильно.
                                                            При необходимости исправь значения полей, а затем пересчитай качество релиза.
                                                            <br><br>Текущие значения полей:<br>
                                                            <ol>
                                                            <li>Срок тестирования тела релиза: {}</li>
                                                            <li>Срок тестирования регресса: {}</li>
                                                            <li>Срок тестирования релиза: {}</li>
                                                            </ol>
                                                            <br>Небольшую инструкцию можно найти здесь: <br>
                                                            https://wiki.yandex-team.ru/users/fanem/release-quality/<br>
                                                            При возникновении вопросов пиши @fanem</p>
                                                    </td>
                                                </tr>
                                            </table>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                        <tr style="background: #5e6874;">
                            <td style="padding: 0 24px 30px; font-size: 14px; line-height: 1.4; text-align: left; color: #fff; background: #5e6874;">
                                <br>С уважением<br>Уведомлятель
                            </td>
                        </tr>
                        <tr>
                            <td style="font-size: 1px; line-height: 1px; padding: 20px 0px 0px 0px;">&nbsp;</td>
                        </tr>
                    </table>
                </div>
            </center>
        </td>
    </tr>
</table>
</body>
</html>"""
