# -*- coding: utf-8 -*-
from __future__ import unicode_literals
from builtins import filter
from datetime import datetime
import urllib3
from startrek_client import Startrek
import requests
from constants import ST_TOKEN, ST_URL, ST_BULK_UPDATE, TIME_FORMAT, QUEUES, STATUS, FILTER

urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)

client = Startrek(useragent="curl/7.53.1", token=ST_TOKEN)


def convert_to_date(str):
    return datetime.strptime(str, TIME_FORMAT)


def get_releases_info(queue):
    issues = client.issues.find(FILTER['FILL_FIELDS'].format(queue))
    for issue in issues:
        print(issue.key)
        issue = client.issues[issue.key]
        update_checklist = list(issue.changelog.get_all(type='IssueUpdated', field='checklistItems'))
        update_fields = list(issue.changelog.get_all(type='IssueUpdated',
                                                     field=('firstRegressionStarted',
                                                            'allTicketsTested',
                                                            'firstRegressionDone',
                                                            'versionReadyRelease')
                                                     ))
        fields = get_last_modify_of_field(update_fields)
        checklist = get_checklist_change(update_checklist)

        if checklist:
            for key in STATUS:
                # field_modifier = fields[key].split("_")[0]
                field_updated_at = fields[key]
                checklist_value = checklist[key].split("_")[0]
                checklist_updated_at = checklist[key].split("_")[1]
                checkbox_modified_after_field = False

                if all(_ != "None" for _ in (checklist_updated_at, field_updated_at)):
                    field_updated_at = convert_to_date(field_updated_at[:19])
                    checklist_updated_at = convert_to_date(checklist_updated_at)
                    checkbox_modified_after_field = (checklist_updated_at > field_updated_at)
                if checklist_updated_at != "None" and field_updated_at == "None":
                    checkbox_modified_after_field = True

                if checkbox_modified_after_field:
                    header = {"Authorization": "OAuth " + ST_TOKEN}
                    r = requests.post(ST_URL + ST_BULK_UPDATE, data=format_data(issue.key, key, checklist_value), headers=header)
                    print(r.text)


def format_data(issue, key, checklist_value):
    issue = '"issues": ["{}"]'.format(issue)
    if checklist_value != "None":
        data = '{' + issue + ', "values": {' + '"{}": "{}"'.format(key, checklist_value[:19]) + '}}'
    else:
        data = '{' + issue + ', "values": {' + '"{}": null'.format(key) + '}}'
    return data


def get_dates_from_fields(issue_data):
    result = {}
    for key in STATUS:
        result.update({key: issue_data[key]})
    return result


def get_last_modify_of_field(update_fields):
    result = {}
    for key in STATUS:
        result.update({key: 'None'})
    for field in update_fields:
        # field_to = str(field.fields[0]['to'])
        # updated_by = field.updatedBy.id
        field_id = field.fields[0]['field'].id
        updated_at = field.updatedAt[:19]
        result.update({field_id: updated_at})  # updated_by + "_" + field_to + "_" +
    return result


def get_checklist_change(update_checklist):
    result = {}

    for checklist in update_checklist:
        checklist_from = checklist.fields[0]['from']
        checklist_to = checklist.fields[0]['to']
        if checklist_from and checklist_to:
            for key, value in STATUS.items():
                if key not in result:
                    result.update({key: "None_None"})
                date = checklist.updatedAt[:19]
                false_to_true = len(list(
                    filter(lambda a: a['checked'] == False and a['text'] in value, checklist_from))) > 0 \
                                and len(list(
                    filter(lambda a: a['checked'] == True and a['text'] in value, checklist_to)))
                true_to_false = len(
                    list(filter(lambda a: a['checked'] == True and a['text'] in value, checklist_from))) > 0 and \
                                len(list(
                                    filter(lambda a: a['checked'] == False and a['text'] in value, checklist_to)))
                if false_to_true:
                    result.update({key: date + "_" + date})
                if true_to_false:
                    result.update({key: "None_" + date})
    return result


if __name__ == '__main__':
    for project in QUEUES:
        get_releases_info(project)
