import os
from dataclasses import dataclass

# Токены
OAUTH_TOKEN_STARTREK = os.environ['OAUTH_TOKEN_STARTREK']
OAUTH_TOKEN_TESTPALM = os.environ['OAUTH_TOKEN_TESTPALM']


TIME_FORMATS = ('%Y-%m-%dT%H:%M:%S.%f', '%Y-%m-%d %H:%M:%S.%f', '%Y-%m-%dT%H:%M:%S.%f%z',
                '%Y-%m-%d %H:%M:%S.%f%z', '%Y-%m-%dT%H:%M:%S', '%Y-%m-%d %H:%M:%S', '%Y-%m-%d')

MAX_UNUSED_CASE_DAYS = 90
MAX_NOT_FINISHED_DAYS = 180
MAX_DAYS_IN_STATUS_DRAFT_ON_REVIEW_NEEDS_CHANGES = 30
IGNORED_VERSIONS = ['iOS_Pre_Release', 'iOS_Responsible_for_release', 'iOS_HotFix_template']

PR_MERGED_SUBSTRING = '**!!(green)MERGED!!**'
ROBOT_MOBDEVTOOLS = 'robot-mobdevtools'


# Команды
@dataclass
class Team:
    ios_dev_lead = ['turaevt']
    ios_dev = ['mahutin', 'turaevt', 'dmitriiabanin']
    android_dev_lead = ['svirikhin']
    android_dev = ['svirikhin', 'stanisvs', 'kimichael', 'svyatoslavdp', 'shumka']
    qa_team = ['fanem', 'chibert', 'a-zoshchuk', 'al-charnyshou']
    qa_lead = ['a-zoshchuk']
    qa_ios = ['fanem']
    qa_android = ['chibert', 'al-charnyshou']
    all = ios_dev + android_dev + qa_team


# Components
@dataclass
class Component:
    ios = 'iOS'
    android = 'Android'


@dataclass(frozen=True)
class Comment:
    add_fix_version = "Привет! К тикету прилинкован PR со статусом Merged, но при этом отсутствует Fix Version. " \
                      "Чтобы тикет не потерялся, проставь, пожалуйста, Fix Version."
    add_release_ticket_fix_version = "Привет! У релизного тикета отсутствует Fix Version. " \
                                     "Чтобы тикет не потерялся, проставь, пожалуйста, Fix Version."
    add_assignee = "Привет! У тикета есть Fix Version, но нет исполнителя. " \
                   "Пожалуйста, добавь исполнителя или убери Fix Version"
    fill_prioritization_fields = "Для определения веса бага необходимо заполнить следующие поля: {}"
    fill_qa_fields = "Необходимо заполнить следующие поля: {}"
    add_new_or_old_inprod_tag = 'Привет! Нужно добавить тег oldInProd или newInProd'
    fix_ticket_negative_weight = 'У тикета отрицательный вес. Разберитесь с этим, пожалуйста.'
    fix_ticket_big_weight = 'У тикета вес больше 300. Обратите на него внимание. SLA - 1 месяц.'
    get_ticket_from_support_in_work = 'Тикет больше 2 недель находится в статусе Open. Разберитесь с ним.'
    fill_fields = "Необходимо заполнить следующие поля: {}"
    change_status_to_testing = 'Проставлен чекбокс "Тестирование "тела" релиза завершено", но тикет не переведен в ' \
                               'статус Testing.'
    change_status_to_tested = 'Проставлен чекбокс "Весь релиз протестирован. Релиз готов к выкатке", но тикет не ' \
                              'переведен в статус Tested/Ready for Release.'
    change_issues_status_to_closed_due_to_release_version = 'Bulk change issues status to Closed due to version release'


@dataclass(frozen=True)
class TestPalmMessages:
    long_time_opened_versions = "<p>В проекте {} есть давно начатые и не закрытые версии.</p><table width='100%'>" \
                                "<tr width='100%'><th>Версия</th><th align='center'>Выполняется, дней</th>" \
                                "<th align='center'>Все раны пройдены</th></tr>{}</table>"
    long_time_opened_version = "<tr><td><a href='https://testpalm.yandex-team.ru/{}/version/{}'>{}</a></td><td align='center'>{}</td><td align='center'>{}</td></tr>"
    unused_cases = 'В проекте {} есть <a href="https://testpalm.yandex-team.ru/{}/testcases?filters={}">кейсы</a>, которые в последний раз ' \
                   'запускались более 3 месяцев назад.<br>Проверь, пожалуйста, актуальность этих кейсов.'
    cases_with_status = 'В проекте {} есть кейсы, долгое время находящиеся в статусах {}.<br><br>' \
                        '<table><tr><th>Статус</th><th align="center">Фильтр</th></tr>{}</table>'
    case_with_status = '<tr width="100%"><td width="30%">{}</td><td width="70%" align="center">' \
                       '<a href="https://testpalm.yandex-team.ru/{}/testcases?filters={}">Кейсы</a></td></tr>'
    header = 'Testpalm notification'


@dataclass(frozen=True)
class TestPalmSubjects:
    unused_cases = 'В проекте {} есть кейсы, которые давно не проходились.'
    long_time_opened_version = 'В проекте {} есть давно начатые и не закрытые версии.'
    cases_with_status = 'В проекте {} есть кейсы, долгое время находящиеся в статусах {}.'


@dataclass(frozen=True)
class Exceptions:
    unknown_project = "Неизвестный проект"
    unknown_component = "Неизвестная компонента"


# Фильтры
@dataclass(frozen=True)
class Query:
    backlog_not_closed_bugs_without_tag_inprod = 'Queue: {} AND (Components: iOS OR Components: Android) ' \
                                                 'AND Status: ! Closed AND Type: Bug AND Tags: ! inProd ' \
                                                 'AND Tags: ! do_not_mark_inprod AND "Fix Version": backlog ' \
                                                 'AND Created: >= today() - 6month '
    not_closed_tickets_with_mobdevtools_robot_comments = 'Queue: {} AND (Components: iOS OR Components: Android) ' \
                                                'AND Status: !Closed AND Status: !"Need Info" ' \
                                                'AND "Fix Version": empty() AND "Comment Author": "robot mobdevtools" ' \
                                                'AND Tags: ! autotest AND Created: >= today() - 6month ' \
                                                'AND "Affected Version": ! iOS_Pre_Release ' \
                                                'AND "Affected Version": ! Android_Pre_Release '
    not_closed_tickets_with_fix_version_and_without_assignee = 'Queue: {} AND (Components: iOS OR Components: Android) ' \
                                                               'AND Status: ! Closed AND "Fix Version": notEmpty() ' \
                                                               'AND "Fix Version": ! backlog AND Assignee: empty() ' \
                                                               'AND Type: ! Release'
    prioritization = 'Queue: {} AND Type: Bug AND Tags: inProd AND Status: ! Closed AND Created: >= today() - 6month ' \
                     'AND (Components: iOS OR Components: Android)'
    bug_detection_method_empty = 'Queue: {} Type: Bug Status: ! Closed Created: >= today() - 6month ' \
                                 '(Components: iOS OR Components: Android) "Bug Detection Method": empty() ' \
                                 '(Stage: Production OR Stage: Beta)'
    stage_empty = 'Queue: {} Type: Bug Status: ! Closed Created: >= today() - 6month (Components: iOS OR ' \
                  'Components: Android) "Stage": empty()'
    cause_of_missing_bug = 'Queue: {} Type: Bug Status: ! Closed Created: >= today() - 6month (Components: iOS OR ' \
                  'Components: Android) (Stage: Production OR Stage: Beta) "Cause Of Missing A Bug": empty()'
    old_tickets_from_support_with_status_open = 'Queue: {} AND Type: Task AND Tags: from_support ' \
                                                'AND Status: changed( to: Open date: <= today() - 14d ) ' \
                                                'AND Status: Open AND Tags: !bug_in_another_service'
    closed_tickets_from_support_with_empty_qa_fields = 'Queue: {} AND Type: Task AND Tags: from_support ' \
                                                       'AND Status: changed( to: Closed date: >= 2021-10-01 by: {}) ' \
                                                       'AND Status: Closed AND QA: empty() AND Components: iOS,Android'
    tickets_with_negative_weight = 'Queue: {} AND (Components: iOS OR Components: Android) AND Type: Bug ' \
                                   'AND Status: ! Closed AND "Weight 1": <0'
    tickets_with_big_weight = 'Queue: {} AND (Components: iOS OR Components: Android) AND Type: Bug ' \
                              'AND Status: ! Closed AND "Weight 1": >=300'
    release = 'Queue: MOBILEMAIL AND Type: Release AND Status: changed( to: Closed date: >= today() - 44d )'
    tickets_without_new_or_old_inprod = 'Queue: {} AND Components: Android, iOS AND Status: Open, "Need Info", Later, ' \
                                        '"In Review", "In Progress", Resolved, Testing, Tested ' \
                                        'AND Resolution: !"Can\'t reproduce", !Duplicate, !"Won\'t fix", ' \
                                        '!"Will Not Fix", !Incomplete, !Invalid, !"Until next complaint", !"Later" ' \
                                        'AND Created: <=now() - 2hours AND Created: >= 01.10.2018 ' \
                                        'AND Type: Bug AND "Bug Detection Method": !Monitoring  ' \
                                        'AND (Stage: Production OR (Stage: Testing AND Tags: inProd)) ' \
                                        'AND (Tags: inProd AND ((Tags: !newInProd AND Tags: !oldInProd) ' \
                                        'OR (Tags: newInProd AND Tags: oldInProd)) OR Tags: !inProd ) ' \
                                        'AND Tags: !do_not_mark_inprod, !mbt, !do_not_check'
    tag_actual_added_long_time_ago = 'Queue: {} AND Tags: Actual AND Tags: changed(to: Actual date: <= today() - 6month) ' \
                                     'AND NOT Tags: changed(to: Actual date: >= today() - 6month) AND Status: ! Closed'


@dataclass(frozen=True)
class Checklist:
    all_tickets_tested = "Тестирование \"тела\" релиза завершено"
    first_regression_started = "Приступили к первой итерации регресса"
    first_regression_done = "Первая итерация регресса завершена"
    version_ready_release = "Весь релиз протестирован. Релиз готов к выкатке"


# Отправка писем
@dataclass(frozen=True)
class MessageSender:
    sender_name = 'Tickets markup'
    sender_email = 'mobmail.reminder@yandex.ru'
    sender_pwd = 'qaz!@#wsx123'
    smpt_domain = 'smtp.yandex.ru'
    smtp_port = 587
    html_body = u"""
<head>
    <meta content="text/html; charset=utf-8" http-equiv="Content-Type"/>
    <meta content="IE=edge" http-equiv="X-UA-Compatible"/>
    <meta content="width=device-width, initial scale=1.0" name="viewport"/>
</head>
<body style="background-color: #F7F7F7; margin: 0px 0px 0px 0px; min-width: 100%; padding: 0px 0px 0px 0px;">
<table bgcolor="#F7F7F7" border="0" cellpadding="0" cellspacing="0"
       style="color: #333333; font-family: sans-serif; line-height: 22px;" width="100%">
    <tr>
        <td style="padding: 0px 0px 0px 0px;">
            <center style="box-sizing: border-box; margin: 0 auto; max-width: 620px; padding: 0px 10px 0px 10px; table-layout: fixed;
                    table-layout: fixed; -webkit-text-size-adjust: 100%; -ms-text-size-adjust: 100%; box-sizing: border-box;
                    padding: 0px 10px 0px 10px; max-width: 620px; margin: 0 auto;">
                <div style="max-width: 600px;">
                    <!--[if (gte mso 9)|(IE)]>
                    <table cellpadding="0" cellspacing="0" border="0" width="600" align="center">
                        <tr>
                            <td>
                    <![endif]-->
                    <table align="center" border="0" cellpadding="0" cellspacing="0" style="color: #333333; font-family: sans-serif; line-height: 22px; max-width: 600px; width: 100%;">
                        <tr>
                            <td style="padding: 25px 0px 12px 0px;">
                                <table border="0" cellpadding="0" cellspacing="0" style="color: #333333; font-family: sans-serif; line-height: 22px; width: 100%;">
                                    <tr>
                                        <td align="left" height="32" style="height: 32px; padding: 0px 0px 0px 0px;" align="top">
                                            <img alt="Яндекс" class="logo"
                                                 src="https://avatars.mds.yandex.net/get-adv/61206/2a000001644bb535090eff58345d3f3c8041/orig"
                                                 height="27" border="0"
                                                 style="display: block; border: 0; color: #010101; font-family: sans-serif; font-size: 24px;">
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                        <tr>
                            <td style="padding: 0px 0px 0px 0px;">
                                <table border="0" cellpadding="0" cellspacing="0" style="background-color: #ffffff; color: #333333; font-family: sans-serif; line-height: 22px; width: 100%;">
                                    <tr>
                                        <td style="padding-left: 40px; padding-right: 40px; padding-bottom: 21px; padding-top: 31px;">
                                            <table border="0" cellpadding="0" cellspacing="0" style="color: #333333; font-family: sans-serif; line-height: 22px;" width="100%">
                                                <tr>
                                                    <td style="padding: 0px 0px 0px 0px; padding-bottom: 5px; text-align: left; width: 100%;">
                                                        <h2>{header}</h2>
                                                        {body}
                                                    </td>
                                                </tr>
                                            </table>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                        <tr style="background: #5e6874;">
                            <td style="padding: 0 24px 30px; font-size: 14px; line-height: 1.4; text-align: left; color: #fff; background: #5e6874;">
                                <br>С уважением<br>Напоминатель
                            </td>
                        </tr>
                        <tr>
                            <td style="font-size: 1px; line-height: 1px; padding: 20px 0px 0px 0px;">&nbsp;</td>
                        </tr>
                    </table>
                </div>
            </center>
        </td>
    </tr>
</table>
</body>
</html>"""
