import argparse
import os

# Script for send all eml files form one folder
# for working script you must install SWAKS ("brew install swaks")
# run script: python3 send_eml.py -to {recipient} -p "path/to/folder/with/eml"
# example for run script: python3 send_eml.py -to h.eloy@yandex.ru -p "/Users/arovkova/Downloads/eml"


def parser_command_line():
    parser = argparse.ArgumentParser(add_help=False)
    argument = parser.add_argument_group(title='Parametrs')

    argument.add_argument('--recipient', '-to', action='store', nargs='?', default=None,
                          help="Email addres for recipient (exp: 'h.eloy@ya.ru', 'h.eloy@ya.ru,un.drake@ya.ru')")

    argument.add_argument('--path', '-p', action='store', nargs='?', default=None,
                          help="Email addres of sender")

    flags = parser.parse_args()
    return flags


if "__main__" == __name__:

    arg = parser_command_line()
    list_eml = os.listdir(path=arg.path)

    for item in list_eml:
        rc = os.system("swaks -t {} -d {}".format(arg.recipient, os.path.join(arg.path, item)))
        if rc:
            print("Error with file {}".format(os.path.join(arg.path, item)))



