import argparse
import datetime
import json
import os
import random
import smtplib

from email.mime.application import MIMEApplication
from email.mime.multipart import MIMEMultipart
from email.mime.text import MIMEText


def output(string):
    print("{date}   {string}".format(date=datetime.datetime.now(), string=string))


def random_string():
    rand_string = ''.join([random.choice(list('123456789qwertyuiopasdfghjklzxcvbnm')) for x in range(12)])
    return rand_string


def get_server_SMTP(login):
    site_smtp = login.split('@')[1]
    server = site_smtp[:-3]
    return server


def parser_command_line():
    parser = argparse.ArgumentParser(add_help=False)

    argument = parser.add_argument_group(title='Parametrs')

    argument.add_argument('--help', '-h', action='help', help='Helper')
    argument.add_argument('--txt', '-t', action='store_const', const=True, default=False, help="Send txt email")
    argument.add_argument('--spam', '-spam', action='store_const', const=True, default=False,
                          help="Send spam email")

    argument.add_argument('--revers', '-r', action='store_const', const=True, default=False,
                          help="Revers of sendler and recipient. if the recipient's and sender's passwords are "
                               "different, enter the new sender's password")

    argument.add_argument('--thread', '-th', action='store', nargs='?', type=int, const=3, default=None,
                          help="Send thread letter. This is count letter in thread ")

    argument.add_argument('--subject', '-subj', action='store', nargs='?', type=str,
                          const="Email was sent by python - {}".format(random_string()), default=None,
                          help="To specify the subject. If no text is specified, random string was generated")

    argument.add_argument('--body_email', '-body', action='store', nargs='?', type=str, default=None,
                          help="To specify the body of email.")

    argument.add_argument('--attach', '-a', action='store', nargs='?', type=int, const=3, default=None,
                          help="Send txt email with attach file (specify the attachment size in MB)")

    argument.add_argument('--count', '-c', action='store', nargs='?', type=int, const=3, default=None,
                          help="Send thread letter. This is count letter in thread ")

    argument.add_argument('--recipient', '-to', action='store', nargs='?', default=None,
                          help="Email addres for recipient (exp: 'h.eloy@ya.ru', 'h.eloy@ya.ru,un.drake@ya.ru')")

    argument.add_argument('--sender', '-user', action='store', nargs='?', default=None,
                          help="Email addres of sender")

    argument.add_argument('--password', '-pwd', action='store', nargs='?', default=None,
                          help="Password of sender")

    flags = parser.parse_args()

    if flags.thread and flags.count:
        output('\x1b[1;31mError:\x1b[0m Use only one of the options: -c OR -th')
        exit()

    if flags.sender and not flags.password:
        output('\x1b[1;31mError:\x1b[0m Password for user wasn\'t found. '
               'Please enter the password for the specified user in \x1b[1m-user\x1b[0m')
        exit()

    if not (flags.sender or flags.revers) and flags.password:
        output('\x1b[1;31mError:\x1b[0m Email for user wasn\'t found. '
               'Please enter the email for the specified password in \x1b[1m-pwd\x1b[0m')
        exit()

    if flags.count and flags.subject:
        output('\x1b[1;33mWarning:\x1b[0m '
               'The specified subject will be replaced with the default one because the \'-C\' parameter is used')

    return flags


class SendEmail:
    def __init__(self, addr, pwd, server, port, recipient, subject, message=None):
        self.user = dict(addr=addr, pwd=pwd)

        self.subject = subject
        self.recipient = recipient
        self.text_msg = message

        self.smtp = smtplib.SMTP_SSL("%s:%s" % (server, port))
        output('SSL Connection to the server is established.')

        self.smtp.login(self.user['addr'], self.user['pwd'])
        output('Authorization was successful.')

    def __exit__(self):
        self.smtp.quit()

    def create_body_mail(self, msg, output_msg=False):
        now = datetime.datetime.now()

        self.msg = MIMEMultipart()
        self.msg['From'] = self.user['addr']
        self.msg['To'] = ', '.join(self.recipient) if isinstance(self.recipient, list) else self.recipient
        self.msg['Subject'] = self.subject

        body = "{} - time - {}".format(msg, str(now))
        self.msg.attach(MIMEText(body))

        # output msg in console
        if output_msg:
            body_msg = "Email:\n\n" \
                       "\t \x1b[4mFrom:\x1b[0m  {}\n" \
                       "\t \x1b[4mTo:\x1b[0m  {}\n" \
                       "\t \x1b[4mSubject:\x1b[0m  {}\n" \
                       "\t \x1b[4mTime in body:\x1b[0m  {}\n".format(self.msg['From'], self.msg['To'],
                                                                     self.msg['Subject'], str(now))

            output(body_msg)

    def send_txt_email(self):
        self.create_body_mail(msg=self.text_msg if self.text_msg else 'Send test email')

        try:
            output('Try send email with\x1b[1m text\x1b[0m ...')
            self.smtp.sendmail(self.user['addr'], self.recipient, self.msg.as_string())
            output('Email was sent \x1b[1;32m successfully!\x1b[0m')
        except Exception as err:
            output('\x1b[1;31mError:\x1b[0m {}'.format(err))


    def send_attach_email(self, attach, size_attach):
        self.create_body_mail(msg=self.text_msg if self.text_msg else 'Send test email with attach')

        current_size = 0
        item = 0

        for f in attach:
            path = os.path.join(os.path.dirname(__file__), f)
            current_size += os.path.getsize(path)

            if current_size > size_attach:
                current_size -= os.path.getsize(path)
                break

            with open(path, "rb") as fil:
                part = MIMEApplication(
                    fil.read(),
                    Name=os.path.basename(path))

            part['Content-Disposition'] = 'attachment; filename="%s"' % os.path.basename(path)
            self.msg.attach(part)
            item += 1

        self.msg.attach(MIMEText("Count attach file = {}".format(item)))

        output("Count attach file = \x1b[1m {} \x1b[0m".format(item))
        output("Size of attach file = \x1b[1m {:.2f} MB\x1b[0m".format(float(current_size / 2 ** 20)))

        try:
            output('Try send email with\x1b[1m attach\x1b[0m ...')
            self.smtp.sendmail(self.user['addr'], self.recipient, self.msg.as_string())
            output('Email was sent \x1b[1;32m successfully!\x1b[0m')
        except Exception as err:
            output('\x1b[1;31mError:\x1b[0m {}'.format(err))


if "__main__" == __name__:
    flags = parser_command_line()

    print('\x1b[1m{:=^30}\x1b[0m'.format('Start'))
    data = json.load(open(os.path.join(os.path.dirname(__file__), 'variable.json')))

    user = flags.sender if flags.sender else data['from_addr']['addr']
    pwd = flags.password if flags.password else data['from_addr']['pwd']
    recipient = list(flags.recipient.split(',')) if flags.recipient else data['to_addrs']
    subject = flags.subject if flags.subject else "Email was sent by python"
    msg = data['spam'] if flags.spam else flags.body_email

    if flags.revers:
        user, recipient = recipient[0], user

    server = get_server_SMTP(user)

    count_letters = 1
    if flags.thread:
        count_letters = flags.thread
    elif flags.count:
        count_letters = flags.count

    # Send mail
    send_email = SendEmail(addr=user,
                           pwd=pwd,
                           server=data[server]['server'],
                           port=data[server]['port'],
                           recipient=recipient,
                           subject=subject,
                           message=msg)

    output('Data about \x1b[1mFrom: {}\x1b[0m'.format(send_email.user['addr']))
    output('Data about \x1b[1mTo: {}\x1b[0m'.format(send_email.recipient))

    for item in range(0, count_letters):
        if flags.count:
            send_email.subject = "Email was sent by python - {}".format(random_string())

        output('Sending \x1b[1m{} of {}\x1b[0m letters...'.format(int(item + 1), count_letters))
        output('Data about \x1b[4mSubject: {}\x1b[0m'.format(send_email.subject))

        if flags.txt or flags.spam:
            send_email.send_txt_email()

        if flags.attach:
            size_attach = flags.attach * 2 ** 20
            send_email.send_attach_email(data['attachs'], size_attach=size_attach)

    print('\x1b[1m{:=^30}\x1b[0m'.format('Finish'))
