# -*- coding: utf-8 -*-
import json
import logging
import os
import requests
import time
import urllib
import urllib.parse
from datetime import date, timedelta

logging.basicConfig(level=logging.INFO)
for k, v in os.environ.items():
    logging.info('%s: %s', k, v)

REPORT_NAME = 'Mobile_Soft_Online/iOS/General/Overall_TCs_in_iOS'
BASE_URL = "https://testpalm.yandex-team.ru:443/api/testcases/mobmail_ios/preview?expression="
TESTPALM_TOKEN = os.environ['TESTPALM_TOKEN']
OAUTH_TOKEN = os.environ['OAUTH_TOKEN']

actual = {
    "type": "EQ",
    "key": "status",
    "value": "actual"
}
drafts = {
    "type": "EQ",
    "key": "status",
    "value": "draft"
}
automated = {
    "type": "EQ",
    "key": "status",
    "value": "automated"
}
automation_in_progress = {
    "type": "EQ",
    "key": "status",
    "value": "automation in progress"
}
on_review = {
    "type": "EQ",
    "key": "status",
    "value": "on review"
}
needs_changes = {
    "type": "EQ",
    "key": "status",
    "value": "needs changes"
}
needs_repair = {
    "type": "EQ",
    "key": "status",
    "value": "needs repair"
}
duplicate = {
    "type": "EQ",
    "key": "status",
    "value": "duplicate"
}
archived = {
    "type": "EQ",
    "key": "status",
    "value": "archived"
}

logging.info("authorization in testpalm has started")

def getTestCasesByFilterNum(runFilter):
    reqHeaders = {"TestPalm-Api-Token": TESTPALM_TOKEN, "Content-Type": "application/json"}

    runFilter = json.dumps(runFilter, ensure_ascii=False, separators=(",", ": "))
    print(runFilter)
    urlBody = urllib.parse.quote(runFilter)

    url = BASE_URL + urlBody

    res = requests.get(url, headers=reqHeaders)

    cases = json.loads(res.text)
    return len(cases)


logging.info("getting the count of testcases in different states")

draftsNum = getTestCasesByFilterNum(drafts)
actualNum = getTestCasesByFilterNum(actual)
on_reviewNum = getTestCasesByFilterNum(on_review)
automatedNum = getTestCasesByFilterNum(automated)
needs_changesNum = getTestCasesByFilterNum(needs_changes)
automation_in_progressNum = getTestCasesByFilterNum(automation_in_progress)
needs_repairNum = getTestCasesByFilterNum(needs_repair)
duplicateNum = getTestCasesByFilterNum(duplicate)
archivedNum = getTestCasesByFilterNum(archived)

print("Всего кейсов в статусе draft: " + str(draftsNum))
print("Всего кейсов в статусе on review: " + str(on_reviewNum))
print("Всего кейсов в статусе actual: " + str(actualNum))
print("Всего кейсов в статусе automated: " + str(automatedNum))
print("Всего кейсов в статусе needs changes: " + str(automatedNum))
print("Всего кейсов в статусе automation in progress: " + str(automation_in_progressNum))
print("Всего кейсов в статусе needs changes: " + str(needs_changesNum))
print("Всего кейсов в статусе duplicate: " + str(duplicateNum))
print("Всего кейсов в статусе archived: " + str(archivedNum))

print(time.strftime(
    (date.today() - timedelta(date.today().weekday())).isoformat()))  # вычисляем дату понедельника нынешней недели
data = [
    {
        "fielddate": time.strftime((date.today() - timedelta(date.today().weekday())).isoformat()),
        # вычисляем дату понедельника нынешней недели
        "drafts": draftsNum,
        "actual": actualNum,
        "automated": automatedNum,
        "on_review": on_reviewNum,
        "automation_in_progress": automation_in_progressNum,
        "needs_changes": needs_changesNum,
        "needs_repair": needs_repairNum,
        "duplicate": duplicateNum,
        "archived": archivedNum
    }
]

logging.info("import data to stat has started")

json_dumps = json.dumps({'values': data})
r = requests.post(
    'https://upload.stat.yandex-team.ru/_api/report/data',
    headers={'Authorization': 'OAuth {token}'.format(token=OAUTH_TOKEN)},
    data={
        'name': REPORT_NAME,
        'scale': 'w',  # указываем, что периодичность отчета 'неделя'
        'json_data': json_dumps,
    }
)
print(r.text)
print(json_dumps)


