# example run
#
# python3 start_autotest_in_team_city.py -b '5087/merge' -a accept
# python3 start_autotest_in_team_city.py -b '5087/merge' -a bl

import argparse
import requests


class Build_type:
    accept = 'mobile_yandex_mail_clients_MobileYandexMailClientAndroidIt_AppiumDevAcceptance'
    bl = 'mobile_yandex_mail_clients_MobileYandexMailClientAndroidIt_AppiumFullBl'


class User:
    NAME = 'robot-mobmail'
    PASSWORD = '***Ky'


class Data_request:
    url = "http://teamcity.yandex-team.ru/app/rest/buildQueue"
    template = '<build branchName="master">' \
               '<triggeringOptions queueAtTop="true"/>' \
               '<buildType id="{buildType}"/>' \
               '<properties>' \
               '<property name="system.branch.name" value="{branch}"/>' \
               '</properties>' \
               '</build>'


def main():
    parser = argparse.ArgumentParser(add_help=False)
    argument = parser.add_argument_group(title='Parametrs')
    argument.add_argument('--branch', '-b', action='store', nargs='?', default=None, help="branch for apk")
    argument.add_argument('--autotest', '-a', action='store', nargs='?', default=None, help="accept/bl")
    flags = parser.parse_args()

    build_id = Build_type.bl if flags.autotest in ['bl', 'BL'] else Build_type.accept
    branch = flags.branch

    headers = {'Content-Type': 'application/xml'}
    data = Data_request.template.format(buildType=build_id, branch=branch)

    requests.post(Data_request.url, headers=headers, data=data, auth=(User.NAME, User.PASSWORD), timeout=10)


if __name__ == '__main__':
    main()
