from __future__ import unicode_literals

import smtplib
from itertools import groupby
from email.mime.multipart import MIMEMultipart
from email.mime.text import MIMEText
from startrek_client import Startrek
from constants import QUERY, LOGINS, PROBLEMS, HTML, ST_TOKEN, SENDER_EMAIL, SENDER_PWD, HEAD, DEFAULT_RECIPIENT

client = Startrek(useragent="curl/7.53.1", token=ST_TOKEN)


def get_issues(query):
    issues = client.issues.find(query)
    if issues:
        return issues
    else:
        print('There are no tickets')
        exit()


def get_issue_data(key):
    issue_data = client.issues[key]
    fields = ['key', 'testingStoryPoints', 'tags', 'description']
    data = {'author': issue_data.createdBy.id}

    for key in fields:
        data.update({key: issue_data[key]})

    return data


def get_email(login):
    if login in LOGINS:
        return [login + "@yandex-team.ru"]
    else:
        return [DEFAULT_RECIPIENT]
        # [login + '@yandex-team.ru' for login in LOGINS]


def find_problem(data):
    problems = []
    env_tag = False
    tsp = data['testingStoryPoints']
    tags = data['tags']
    description = data['description'].replace(' ', '').lower()
    practice_tag = 'Resolve_QA'
    inf_for_assessors = 'информациядля'

    if tsp is None:
        problems.append(PROBLEMS['no_tsp'])
    if practice_tag not in tags:
        problems.append(PROBLEMS['no_practice_tag'])

    for tag in tags:
        if 'Env:' in tag:
            env_tag = True
            break

    if not env_tag:
        problems.append(PROBLEMS['no_env_tag'])
    if inf_for_assessors not in description:
        problems.append(PROBLEMS['no_inf_for_assessors'])

    if problems:
        return u'''В тикете <a href=https://st.yandex-team.ru/{}>{}</a> необходимо: <br> <ul> <li>{}</li></ul>'''.format(
            data['key'],
            data['key'],
            "</li> <li>".join(problems)
        )
    else:
        return None


def create_message(problems):
    subject = 'Неразмеченные тикеты'
    body = HTML.format(problems)
    return subject, body


def send_mail(subject, message, to):
    msg = MIMEMultipart('alternative')
    msg['Subject'] = subject
    msg['From'] = 'Tickets markup <{}>'.format(SENDER_EMAIL)
    msg['To'] = ','.join(to)
    msg.attach(MIMEText(message.encode('utf-8'), 'html', 'utf-8'))

    sender = SENDER_EMAIL
    sender_password = SENDER_PWD

    try:
        smtp_object = smtplib.SMTP('smtp.yandex.ru', 587)
        smtp_object.ehlo()
        smtp_object.starttls()
        smtp_object.login(sender, sender_password)
        smtp_object.sendmail(sender, to, msg.as_string())
        print('Successfully sent email to: %s' % to)
    except RuntimeError as err:
        print(err)


if __name__ == '__main__':
    issues = get_issues(QUERY)
    data = []
    all_problems = ""

    for issue in issues:
        data.append(get_issue_data(issue.key))

    for k, issues in groupby(sorted(data, key=lambda x: x['author']), lambda x: x['author']):
        problems, recipient = '', ''

        for issue in issues:
            recipient = get_email(issue['author'])
            problem = find_problem(issue)
            if problem:
                problems = problems + problem + "<br>"

        if not problems:
            continue

        all_problems = all_problems + problems + "<br>"

        subject, body = create_message(problems)
        send_mail(subject, body, recipient)

    subject, body = create_message(all_problems)
    send_mail(subject, body, HEAD)
