# Before use:
# pip install -i https://pypi.yandex-team.ru/simple/ startrek_client

from enum import Enum
import logging
import requests
import time
import urllib3
from startrek_client import Startrek

APPLICATION = 'TestPalm'
TAG = 'link_delete'

TOKEN_ST = 'AQAD-****'
USER = 'arovkova'

QUEUE = 'MOBILEMAILEXP-5808'
FILTER = 'Queue: Mobilemailexp AND Tags: "2222"'


def check_return_code(request):
    status_OK = [200, 201, 204]

    if not status_OK.count(request.status_code):
        print('\033[91m Error\033[00m in request. Status code = {}, reason = {}'.
              format(request.status_code, request.reason))


def get_remote_link(headers, key_ticket):
    data = requests.get(f"https://st-api.yandex-team.ru/v2/issues/{key_ticket}/remotelinks", headers=headers)
    return data.json()


def delete_testpalm_link(headers, array_links, key_ticket):
    for link in array_links:
        name_link = link['object']['application']['name']
        id_link = link['id']

        if name_link == APPLICATION:
            r = requests.delete(f'https://st-api.yandex-team.ru/v2/issues/{key_ticket}/remotelinks/{id_link}',
                                headers=headers)
            check_return_code(r)


def delete_by_filter():
    headers_startrek = {
        'Authorization': f"OAuth {TOKEN_ST}",
        'Content-Type': 'application/json',
        'User-Agent': 'curl/7.53.1',
        'Connection': 'close',
        'Accept': '*/*'}

    urllib3.disable_warnings()
    client = Startrek(base_url='https://st-api.yandex-team.ru',
                      useragent=USER,
                      token=TOKEN_ST)

    filter_for_delete_link = f"{FILTER} AND Tags: ! {TAG}"
    filter_for_delete_don_tag = f"{FILTER} AND Tags: {TAG}"

    issues = client.issues.find(filter_for_delete_link)

    while len(issues):
        for item in issues:
            item.update(tags={'add': [TAG]})
            links = get_remote_link(headers=headers_startrek, key_ticket=item.key)
            delete_testpalm_link(headers=headers_startrek, array_links=links, key_ticket=item.key)
            logging.info("Link  was deleted for ticket {}".format(item.key))
        time.sleep(7)
        issues = client.issues.find(filter_for_delete_link)

    logging.info(f"Delete tag {TAG}...")
    issues = client.issues.find(filter_for_delete_don_tag)

    while len(issues):
        for item in issues:
            item.update(tags={'remove': [TAG]})
            logging.info("Link  was deleted for ticket {}".format(item.key))
        time.sleep(7)
        issues = client.issues.find(filter_for_delete_don_tag)


def delete_from_one_ticket(key):
    headers_startrek = {
        'Authorization': f"OAuth {TOKEN_ST}",
        'Content-Type': 'application/json',
        'User-Agent': 'curl/7.53.1',
        'Connection': 'close',
        'Accept': '*/*'}

    links = get_remote_link(headers=headers_startrek, key_ticket=key)
    delete_testpalm_link(headers=headers_startrek, array_links=links, key_ticket=key)


def main():
    delete_by_filter()
    # delete_from_one_ticket("MOBILEMAILEXP-508")


if __name__ == '__main__':
        main()
delete_by_filter()
