# Before use:
# pip install -i https://pypi.yandex-team.ru/simple/ startrek_client

from enum import Enum
import logging
import time
import urllib3
from startrek_client import Startrek


class Data_for_ST(Enum):
    FILTER = 'Queue: "Yandex Mobile Mail" AND Type: Bug AND Tags: newInProd AND Tags: pony_done'
    TAG = 'pony_done'


class User(Enum):
    TOKEN_ST = '***'
    NAME = 'robot-mobmailstat'


def main():
    urllib3.disable_warnings()
    client = Startrek(base_url='https://st-api.yandex-team.ru',
                      useragent=User.NAME.value,
                      token=User.TOKEN_ST.value)

    issues = client.issues.find(Data_for_ST.FILTER.value)

    while len(issues):
        for ticket in issues:
            item = client.issues[ticket.key]
            item.update(tags={'remove': [Data_for_ST.TAG.value]}, ignore_version_change=True)
            logging.info("Tag {} delete for ticket {}".format(Data_for_ST.TAG.value, item.key))
        time.sleep(7)
        issues = client.issues.find(Data_for_ST.FILTER.value)


if __name__ == '__main__':
    main()
