# Before use:
# pip install -i https://pypi.yandex-team.ru/simple/ startrek_client


from enum import Enum
import logging
import time
import urllib3
from startrek_client import Startrek


class Data_for_ST(Enum):
    FILTER = 'Queue: MOBILEMAIL AND Components: Android AND "Affected Version": "Android 4.0.2"'


class User(Enum):
    NAME = 'arovkova'
    TOKEN_ST = 'AQAD-******'


def main():
    urllib3.disable_warnings()
    client = Startrek(base_url='https://st-api.yandex-team.ru',
                      useragent=User.NAME.value,
                      token=User.TOKEN_ST.value)

    issues = client.issues.find(Data_for_ST.FILTER.value)

    while len(issues):
        for item in issues:
            item.update(weight=int(item.weightOne) * 10)
            logging.info("The weight was updated for ticket {}".format(item.key))
        time.sleep(7)
        issues = client.issues.find(Data_for_ST.FILTER.value)


if __name__ == '__main__':
    main()
