import json
import re
import requests
from datetime import datetime

HOLIDAYS_URL = "https://api.calendar.yandex-team.ru/intapi/get-holidays?from=DATE&to=DATE&for=rus"
CACHE_FILE = "/tmp/is_holiday"


def get_today():
    return str(datetime.date(datetime.now()))


def check_holiday(date=get_today()):
    try:
        with open(CACHE_FILE) as f:
            day_info = json.load(f)
            return day_info[date]
    except (IOError, ValueError, KeyError):
        url = re.sub("DATE", date, HOLIDAYS_URL)
        holiday_info = requests.get(url).json()["holidays"]
        is_holiday = True if len(holiday_info) else False
        if date == get_today():
            with open(CACHE_FILE, "w") as f:
                json.dump({date: is_holiday}, f)
        return is_holiday
