import requests
import socket


CONDUCTOR_GROUP_URL = "http://c.yandex-team.ru/api/hosts2groups/"
CONDUCTOR_DC_URL = "http://c.yandex-team.ru/api/generator/hosts2dc?fqdn="
CONDUCTOR_GROUP_FILE = "/var/tmp/cond_group.conf"
CONDUCTOR_DC_FILE = "/var/tmp/cond_dc.conf"
DEFAULT_CONDUCTOR_TIMEOUT = 3


def get_group():
    try:
        with open(CONDUCTOR_GROUP_FILE, "r") as f:
            cond_group = f.read().split()[0]
    except IOError:
        cond_group = requests.get(
            CONDUCTOR_GROUP_URL + socket.getfqdn() + "?format=json", timeout=DEFAULT_CONDUCTOR_TIMEOUT).json()[0]["name"]
        with open(CONDUCTOR_GROUP_FILE, "w") as f:
            f.write(cond_group + "\n")
    return cond_group


def get_dc():
    try:
        with open(CONDUCTOR_DC_FILE, "r") as f:
            cond_dc = f.read().split()[0]
    except IOError:
        cond_dc = requests.get(
            CONDUCTOR_DC_URL + socket.getfqdn(), timeout=DEFAULT_CONDUCTOR_TIMEOUT).text.split()[1]
        with open(CONDUCTOR_DC_FILE, "w") as f:
            f.write(cond_dc + "\n")
    return cond_dc.upper()
