import json
import os
import requests

POD_ATTRIBUTES_API="http://localhost:1/pod_attributes"
POD_ATTRIBUTES_FILE="/tmp/pod_attributes.json"


class Environment(object):

    def __init__(self):
        self.is_init = False

    def create_env(self):
        if not os.path.exists(POD_ATTRIBUTES_FILE):
            pod_attr_data = json.loads(requests.get(POD_ATTRIBUTES_API).text)
            with open(POD_ATTRIBUTES_FILE, "w") as f:
                f.write(json.dumps(pod_attr_data, indent=4))
        self.data = json.load(open(POD_ATTRIBUTES_FILE))
        self.is_init = True

    def __repr__(self):
        if not self.is_init:
            self.create_env()
        return str(self.data)

    def __getitem__(self, key):
        if not self.is_init:
            self.create_env()
        return self.data[key]


def is_deploy():
    if os.path.exists(POD_ATTRIBUTES_FILE):
        return True
    try:
        environ.create_env()
        return True
    except:
        return False


environ = Environment()
