import socket
from urllib2 import urlopen
import time
import os
import json

project = "mail"

host = socket.gethostname().replace('.', '_')

qloud_env_file = '/etc/qloud/meta.json'

GRAPHITE_PREFIX_ = None


def get_conductor_group():
    try:
        f = open('/var/cond_group', 'r')
        cond_group = f.read().split()[0]
        f.close()
    except:
        cond_group = json.loads(urlopen("http://c.yandex-team.ru/api/hosts2groups/" +
                                        socket.gethostname() + "?format=json").read())[0]['name']
        f = open('/var/cond_group', 'w')
        f.write(cond_group + "\n")
        f.close()
    return cond_group


def get_qloud_prefix():
    with open(qloud_env_file) as f:
        qloud_env = json.loads(f.read())
    qloud_prefix = ".".join([
        qloud_env['qloud_project'],
        qloud_env['qloud_application'],
        qloud_env['qloud_environment'],
        qloud_env['user_environment']['QLOUD_COMPONENT'],
        qloud_env['qloud_instance']
        ])
    return qloud_prefix


def get_graphite_prefix():
    global GRAPHITE_PREFIX_

    if GRAPHITE_PREFIX_:
        return GRAPHITE_PREFIX_

    if os.path.exists(qloud_env_file):
        GRAPHITE_PREFIX_ = get_qloud_prefix()
    else:
        cond_group = get_conductor_group()
        GRAPHITE_PREFIX_ = project + "." + cond_group + "." + host

    return GRAPHITE_PREFIX_


timestamp = int(time.time())
