import subprocess
import re


def get_maillog(log_file='/var/log/maillog', time=60, app=False):
    str_log = ('timetail -t syslog -n ' + str(time) + ' ' + log_file).split()
    p = subprocess.Popen(str_log, stdout=subprocess.PIPE)
    maillog = p.communicate()[0].splitlines()
    if app:
        app_log = []
        for line in maillog:
            if re.search(app, line.split()[4]):
                app_log.append(line)
        return app_log
    return maillog
