from collections import defaultdict

OK = 0
WARNING = 1
CRITICAL = 2


def _desc_to_str(description, firstLevel=False):
    brackets = "{}" if firstLevel else "{{{}}}"
    if isinstance(description, defaultdict):
        description = ", ".join("{}={}".format(k, _desc_to_str(v)) for k, v in description.iteritems())
        description = brackets.format(description)
    elif isinstance(description, (list, tuple)):
        description = "; ".join("{}".format(_desc_to_str(v)) for v in description)
        description = brackets.format(description)
    return description


def report(status, description, suffix=None):
    description = _desc_to_str(description, True)
    if not description and description != 0:
        description = "empty"
    if suffix:
        description = suffix + ", " + description
    print "%d;%s" % (status, description)
