import json
import re
import os
from urllib2 import urlopen, Request

ENVIRONMENT_FILE = "/etc/qloud/meta.json"

QLOUD_KEY_FILE = "/etc/qloud.key"
QLOUD_API = 'https://qloud-ext.yandex-team.ru/api/v1/status/'


class Environment(object):
    def __init__(self):
        self.is_init = False

    def create_env(self):
        self.data = json.load(open(ENVIRONMENT_FILE))
        self.is_init = True

    def __repr__(self):
        if not self.is_init:
            self.create_env()
        return str(self.data)

    def __getitem__(self, key):
        if not self.is_init:
            self.create_env()
        return self.data[key]

    @property
    def user(self):
        if not self.is_init:
            self.create_env()
        return self.data["user_environment"]

    @property
    def is_corp(self):
        if not self.is_init:
            self.create_env()
        return True if re.search("-corp$", self.data["qloud_application"]) else False


environ = Environment()


def get_qloud_token():
    with open(QLOUD_KEY_FILE) as f:
        return f.read().strip()


def is_qloud():
    return os.path.exists(ENVIRONMENT_FILE)


def get_component_path():
    qloud_path = ".".join([
        environ["qloud_project"],
        environ["qloud_application"],
        environ["qloud_environment"],
        environ.user["QLOUD_COMPONENT"]
    ])
    return qloud_path


def get_qloud_instances(qloud_path, dc=False, name=False):
    qloud_token = get_qloud_token()
    request = Request(QLOUD_API + qloud_path,
                      headers={"Authorization": "OAuth " + qloud_token})
    contents = json.loads(urlopen(request).read())
    instances = []
    for instance in contents:
        if instance['instanceCurrentState'] == 'ACTIVE':
            if dc:
                instances.append(
                    {'fqdn': instance['instanceFqdn'], 'dc': instance['dc']})
                continue
            if name:
                instances.append(
                    {'fqdn': instance['instanceFqdn'], 'name': instance['instanceName']})
                continue
            instances.append(instance['instanceFqdn'])
    return instances
